/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.routes;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.population.routes.AbstractRoute;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class ExperimentalTransitRoute
extends AbstractRoute {
    private static final String SEPARATOR = "===";
    private static final String IDENTIFIER_1 = "PT1===";
    static final String ROUTE_TYPE = "experimentalPt1";
    private Id<TransitStopFacility> accessStopId = null;
    private Id<TransitStopFacility> egressStopId = null;
    private Id<TransitLine> lineId = null;
    private Id<TransitRoute> routeId = null;
    private String description = null;
    private String routeDescription;

    ExperimentalTransitRoute(Id<Link> startLinkId, Id<Link> endLinkId) {
        super(startLinkId, endLinkId);
    }

    public ExperimentalTransitRoute(TransitStopFacility accessFacility, TransitStopFacility egressFacility, Id<TransitLine> lineId, Id<TransitRoute> routeId) {
        this(accessFacility.getLinkId(), egressFacility.getLinkId());
        this.accessStopId = accessFacility.getId();
        this.lineId = lineId;
        this.routeId = routeId;
        this.egressStopId = egressFacility.getId();
    }

    public ExperimentalTransitRoute(TransitStopFacility accessFacility, TransitLine line, TransitRoute route, TransitStopFacility egressFacility) {
        this(accessFacility, egressFacility, line == null ? null : line.getId(), route == null ? null : route.getId());
    }

    @Override
    public ExperimentalTransitRoute clone() {
        return (ExperimentalTransitRoute)super.clone();
    }

    public Id<TransitStopFacility> getAccessStopId() {
        return this.accessStopId;
    }

    public Id<TransitStopFacility> getEgressStopId() {
        return this.egressStopId;
    }

    public Id<TransitLine> getLineId() {
        return this.lineId;
    }

    public Id<TransitRoute> getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteDescription(String routeDescription) {
        this.routeDescription = routeDescription;
        if (routeDescription.startsWith(IDENTIFIER_1)) {
            String[] parts = routeDescription.split(SEPARATOR, 6);
            this.accessStopId = Id.create(parts[1], TransitStopFacility.class);
            this.lineId = Id.create(parts[2], TransitLine.class);
            this.routeId = Id.create(parts[3], TransitRoute.class);
            this.egressStopId = Id.create(parts[4], TransitStopFacility.class);
            this.description = parts.length > 5 ? parts[5] : null;
        } else {
            this.accessStopId = null;
            this.lineId = null;
            this.egressStopId = null;
        }
    }

    @Override
    public String getRouteDescription() {
        if (this.accessStopId == null) {
            return this.routeDescription;
        }
        String str = IDENTIFIER_1 + this.accessStopId.toString() + SEPARATOR + this.lineId.toString() + SEPARATOR + this.routeId.toString() + SEPARATOR + this.egressStopId.toString();
        if (this.description != null) {
            str = str + SEPARATOR + this.description;
        }
        return str;
    }

    @Override
    public String getRouteType() {
        return ROUTE_TYPE;
    }

    @Override
    public String toString() {
        return "[ExpTransitRoute: access=" + this.accessStopId.toString() + " egress=" + this.egressStopId + " line=" + this.lineId + " route=" + this.routeId + " ]";
    }
}

