/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.Id;
import org.matsim.core.utils.misc.Time;
import org.matsim.pt.transitSchedule.api.MinimalTransferTimes;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

class MinimalTransferTimesImpl
implements MinimalTransferTimes {
    private Map<Id<TransitStopFacility>, Map<Id<TransitStopFacility>, Double>> minimalTransferTimes = new ConcurrentHashMap<Id<TransitStopFacility>, Map<Id<TransitStopFacility>, Double>>();

    MinimalTransferTimesImpl() {
    }

    @Override
    public double set(Id<TransitStopFacility> fromStop, Id<TransitStopFacility> toStop, double seconds) {
        if (Double.isNaN(seconds) || Time.isUndefinedTime(seconds)) {
            return this.remove(fromStop, toStop);
        }
        Map innerMap = this.minimalTransferTimes.computeIfAbsent(fromStop, key -> new ConcurrentHashMap());
        Double value = innerMap.put(toStop, seconds);
        if (value == null) {
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public double get(Id<TransitStopFacility> fromStop, Id<TransitStopFacility> toStop) {
        return this.get(fromStop, toStop, Double.NaN);
    }

    @Override
    public double get(Id<TransitStopFacility> fromStop, Id<TransitStopFacility> toStop, double defaultSeconds) {
        Map<Id<TransitStopFacility>, Double> innerMap = this.minimalTransferTimes.get(fromStop);
        if (innerMap == null) {
            return defaultSeconds;
        }
        Double value = innerMap.get(toStop);
        if (value == null) {
            return defaultSeconds;
        }
        return value;
    }

    @Override
    public double remove(Id<TransitStopFacility> fromStop, Id<TransitStopFacility> toStop) {
        Map<Id<TransitStopFacility>, Double> innerMap = this.minimalTransferTimes.get(fromStop);
        if (innerMap == null) {
            return Double.NaN;
        }
        Double value = innerMap.remove(toStop);
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    @Override
    public MinimalTransferTimes.MinimalTransferTimesIterator iterator() {
        return new MinimalTransferTimesIteratorImpl(this.minimalTransferTimes);
    }

    private static class MinimalTransferTimesIteratorImpl
    implements MinimalTransferTimes.MinimalTransferTimesIterator {
        private Id<TransitStopFacility> nextFromStopId = null;
        private Id<TransitStopFacility> fromStopId = null;
        private Id<TransitStopFacility> toStopId = null;
        private double seconds = Double.NaN;
        private boolean hasElement = false;
        private Iterator<Map.Entry<Id<TransitStopFacility>, Map<Id<TransitStopFacility>, Double>>> outerIterator;
        private Iterator<Map.Entry<Id<TransitStopFacility>, Double>> innerIterator;

        MinimalTransferTimesIteratorImpl(Map<Id<TransitStopFacility>, Map<Id<TransitStopFacility>, Double>> values) {
            this.outerIterator = values.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.innerIterator != null && this.innerIterator.hasNext()) {
                return true;
            }
            while (this.outerIterator.hasNext()) {
                Map.Entry<Id<TransitStopFacility>, Map<Id<TransitStopFacility>, Double>> outerEntry = this.outerIterator.next();
                Map<Id<TransitStopFacility>, Double> innerMap = outerEntry.getValue();
                this.innerIterator = innerMap.entrySet().iterator();
                if (!this.innerIterator.hasNext()) continue;
                this.nextFromStopId = outerEntry.getKey();
                return true;
            }
            this.nextFromStopId = null;
            return false;
        }

        @Override
        public void next() {
            if (this.innerIterator == null || !this.innerIterator.hasNext()) {
                this.hasElement = false;
                throw new NoSuchElementException();
            }
            Map.Entry<Id<TransitStopFacility>, Double> e = this.innerIterator.next();
            this.fromStopId = this.nextFromStopId;
            this.toStopId = e.getKey();
            this.seconds = e.getValue();
            this.hasElement = true;
        }

        @Override
        public Id<TransitStopFacility> getFromStopId() {
            if (this.hasElement) {
                return this.fromStopId;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Id<TransitStopFacility> getToStopId() {
            if (this.hasElement) {
                return this.toStopId;
            }
            throw new NoSuchElementException();
        }

        @Override
        public double getSeconds() {
            if (this.hasElement) {
                return this.seconds;
            }
            throw new NoSuchElementException();
        }
    }
}

