/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class TransitLineImpl
implements TransitLine {
    private final Id<TransitLine> lineId;
    private String name = null;
    private final Map<Id<TransitRoute>, TransitRoute> transitRoutes = new LinkedHashMap<Id<TransitRoute>, TransitRoute>(5);
    private final Attributes attributes = new Attributes();

    protected TransitLineImpl(Id<TransitLine> id) {
        this.lineId = id;
    }

    @Override
    public Id<TransitLine> getId() {
        return this.lineId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void addRoute(TransitRoute transitRoute) {
        Id id = transitRoute.getId();
        if (this.transitRoutes.containsKey(id)) {
            throw new IllegalArgumentException("There is already a transit route with id " + id.toString() + " with line " + this.lineId);
        }
        this.transitRoutes.put(id, transitRoute);
    }

    @Override
    public Map<Id<TransitRoute>, TransitRoute> getRoutes() {
        return Collections.unmodifiableMap(this.transitRoutes);
    }

    @Override
    public boolean removeRoute(TransitRoute route) {
        return null != this.transitRoutes.remove(route.getId());
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "[TransitLineImpl: line=" + this.lineId.toString() + ", #routes=" + this.transitRoutes.size() + "]";
    }
}

