/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.matsim.api.core.v01.Id;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class TransitRouteImpl
implements TransitRoute {
    private final Id<TransitRoute> routeId;
    private NetworkRoute route;
    private final List<TransitRouteStop> stops = new ArrayList<TransitRouteStop>(8);
    private String description = null;
    private final Map<Id<Departure>, Departure> departures = new TreeMap<Id<Departure>, Departure>();
    private String transportMode;
    private String direction;
    private final Attributes attributes = new Attributes();

    protected TransitRouteImpl(Id<TransitRoute> id, NetworkRoute route, List<TransitRouteStop> stops, String transportMode) {
        this.routeId = id;
        this.route = route;
        this.stops.addAll(stops);
        this.transportMode = transportMode;
    }

    @Override
    public Id<TransitRoute> getId() {
        return this.routeId;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setTransportMode(String mode) {
        this.transportMode = mode;
    }

    @Override
    public String getTransportMode() {
        return this.transportMode;
    }

    @Override
    public void addDeparture(Departure departure) {
        Id id = departure.getId();
        if (this.departures.containsKey(id)) {
            throw new IllegalArgumentException("There is already a departure with id " + id.toString() + " in transit route " + this.routeId);
        }
        this.departures.put(id, departure);
    }

    @Override
    public boolean removeDeparture(Departure departure) {
        return null != this.departures.remove(departure.getId());
    }

    @Override
    public Map<Id<Departure>, Departure> getDepartures() {
        return Collections.unmodifiableMap(this.departures);
    }

    @Override
    public NetworkRoute getRoute() {
        return this.route;
    }

    @Override
    public void setRoute(NetworkRoute route) {
        this.route = route;
    }

    @Override
    public List<TransitRouteStop> getStops() {
        return Collections.unmodifiableList(this.stops);
    }

    @Override
    public TransitRouteStop getStop(TransitStopFacility stop) {
        for (TransitRouteStop trStop : this.stops) {
            if (stop != trStop.getStopFacility()) continue;
            return trStop;
        }
        return null;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "[TransitRouteImpl: route=" + this.routeId.toString() + ", #departures=" + this.departures.size() + "]";
    }
}

