/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.matsim.api.core.v01.Id;
import org.matsim.pt.transitSchedule.MinimalTransferTimesImpl;
import org.matsim.pt.transitSchedule.api.MinimalTransferTimes;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitScheduleFactory;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class TransitScheduleImpl
implements TransitSchedule {
    private final Map<Id<TransitLine>, TransitLine> transitLines = new TreeMap<Id<TransitLine>, TransitLine>();
    private final Map<Id<TransitStopFacility>, TransitStopFacility> stopFacilities = new TreeMap<Id<TransitStopFacility>, TransitStopFacility>();
    private final TransitScheduleFactory factory;
    private final ObjectAttributes transitLinesAttributes = new ObjectAttributes();
    private final ObjectAttributes transitStopsAttributes = new ObjectAttributes();
    private final Attributes attributes = new Attributes();
    private final MinimalTransferTimes minimalTransferTimes = new MinimalTransferTimesImpl();

    protected TransitScheduleImpl(TransitScheduleFactory builder) {
        this.factory = builder;
    }

    @Override
    public void addTransitLine(TransitLine line) {
        Id id = line.getId();
        if (this.transitLines.containsKey(id)) {
            throw new IllegalArgumentException("There is already a transit line with id " + id.toString());
        }
        this.transitLines.put(id, line);
    }

    @Override
    public boolean removeTransitLine(TransitLine line) {
        TransitLine oldLine = this.transitLines.remove(line.getId());
        if (oldLine == null) {
            return false;
        }
        if (oldLine != line) {
            this.transitLines.put(oldLine.getId(), oldLine);
            return false;
        }
        return true;
    }

    @Override
    public void addStopFacility(TransitStopFacility stop) {
        Id id = stop.getId();
        if (this.stopFacilities.containsKey(id)) {
            throw new IllegalArgumentException("There is already a stop facility with id " + id.toString());
        }
        this.stopFacilities.put(id, stop);
    }

    @Override
    public Map<Id<TransitLine>, TransitLine> getTransitLines() {
        return Collections.unmodifiableMap(this.transitLines);
    }

    @Override
    public Map<Id<TransitStopFacility>, TransitStopFacility> getFacilities() {
        return Collections.unmodifiableMap(this.stopFacilities);
    }

    @Override
    public boolean removeStopFacility(TransitStopFacility stop) {
        TransitStopFacility oldStop = this.stopFacilities.remove(stop.getId());
        if (oldStop == null) {
            return false;
        }
        if (oldStop != stop) {
            this.stopFacilities.put(oldStop.getId(), oldStop);
            return false;
        }
        return true;
    }

    @Override
    public TransitScheduleFactory getFactory() {
        return this.factory;
    }

    @Override
    public ObjectAttributes getTransitLinesAttributes() {
        return this.transitLinesAttributes;
    }

    @Override
    public ObjectAttributes getTransitStopsAttributes() {
        return this.transitStopsAttributes;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public MinimalTransferTimes getMinimalTransferTimes() {
        return this.minimalTransferTimes;
    }
}

