/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.matsim.pt.transitSchedule.DepartureImpl;
import org.matsim.pt.transitSchedule.TransitRouteStopImpl;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;
import org.xml.sax.Attributes;

public class TransitScheduleReaderV1
extends MatsimXmlParser {
    private final TransitSchedule schedule;
    private final RouteFactories routeFactory;
    private TransitLine currentTransitLine = null;
    private TempTransitRoute currentTransitRoute = null;
    private TempRoute currentRouteProfile = null;
    private final CoordinateTransformation coordinateTransformation;
    private final StringCache cache = new StringCache();

    public TransitScheduleReaderV1(TransitSchedule schedule, RouteFactories routeFactory) {
        this(new IdentityTransformation(), schedule, routeFactory);
    }

    public TransitScheduleReaderV1(Scenario scenario) {
        this(scenario.getTransitSchedule(), scenario.getPopulation().getFactory().getRouteFactories());
    }

    public TransitScheduleReaderV1(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        this(coordinateTransformation, scenario.getTransitSchedule(), scenario.getPopulation().getFactory().getRouteFactories());
    }

    public TransitScheduleReaderV1(CoordinateTransformation coordinateTransformation, TransitSchedule schedule, RouteFactories routeFactory) {
        this.coordinateTransformation = coordinateTransformation;
        this.schedule = schedule;
        this.routeFactory = routeFactory;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if ("stopFacility".equals(name)) {
            boolean isBlocking = Boolean.parseBoolean(atts.getValue("isBlocking"));
            TransitStopFacility stop = this.schedule.getFactory().createTransitStopFacility(Id.create(atts.getValue("id"), TransitStopFacility.class), this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")))), isBlocking);
            if (atts.getValue("linkRefId") != null) {
                Id<Link> linkId = Id.create(atts.getValue("linkRefId"), Link.class);
                stop.setLinkId(linkId);
            }
            if (atts.getValue("name") != null) {
                stop.setName(this.cache.get(atts.getValue("name")));
            }
            this.schedule.addStopFacility(stop);
        } else if ("transitLine".equals(name)) {
            Id<TransitLine> id = Id.create(atts.getValue("id"), TransitLine.class);
            this.currentTransitLine = this.schedule.getFactory().createTransitLine(id);
            if (atts.getValue("name") != null) {
                this.currentTransitLine.setName(atts.getValue("name"));
            }
            this.schedule.addTransitLine(this.currentTransitLine);
        } else if ("transitRoute".equals(name)) {
            Id<TransitRoute> id = Id.create(atts.getValue("id"), TransitRoute.class);
            this.currentTransitRoute = new TempTransitRoute(id);
        } else if ("departure".equals(name)) {
            Id<Departure> id = Id.create(atts.getValue("id"), Departure.class);
            DepartureImpl departure = new DepartureImpl(id, Time.parseTime(atts.getValue("departureTime")));
            String vehicleRefId = atts.getValue("vehicleRefId");
            if (vehicleRefId != null) {
                departure.setVehicleId(Id.create(vehicleRefId, Vehicle.class));
            }
            this.currentTransitRoute.departures.put(id, departure);
        } else if ("routeProfile".equals(name)) {
            this.currentRouteProfile = new TempRoute();
        } else if ("link".equals(name)) {
            String linkStr = atts.getValue("refId");
            if (!linkStr.contains(" ")) {
                this.currentRouteProfile.addLink(Id.create(linkStr, Link.class));
            } else {
                String[] links = linkStr.split(" ");
                for (int i = 0; i < links.length; ++i) {
                    this.currentRouteProfile.addLink(Id.create(links[i], Link.class));
                }
            }
        } else if ("stop".equals(name)) {
            Id<TransitStopFacility> id = Id.create(atts.getValue("refId"), TransitStopFacility.class);
            TransitStopFacility facility = this.schedule.getFacilities().get(id);
            if (facility == null) {
                throw new RuntimeException("no stop/facility with id " + atts.getValue("refId"));
            }
            TempStop stop = new TempStop(facility);
            String arrival = atts.getValue("arrivalOffset");
            String departure = atts.getValue("departureOffset");
            if (arrival != null) {
                stop.arrival = Time.parseTime(arrival);
            }
            if (departure != null) {
                stop.departure = Time.parseTime(departure);
            }
            stop.awaitDeparture = Boolean.parseBoolean(atts.getValue("awaitDeparture"));
            this.currentTransitRoute.stops.add(stop);
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if ("description".equals(name) && "transitRoute".equals(context.peek())) {
            this.currentTransitRoute.description = content;
        } else if ("transportMode".equals(name)) {
            this.currentTransitRoute.mode = content.intern();
        } else if ("transitRoute".equals(name)) {
            ArrayList<TransitRouteStop> stops = new ArrayList<TransitRouteStop>(this.currentTransitRoute.stops.size());
            for (TempStop tStop : this.currentTransitRoute.stops) {
                TransitRouteStopImpl routeStop = new TransitRouteStopImpl(tStop.stop, tStop.arrival, tStop.departure);
                stops.add(routeStop);
                routeStop.setAwaitDepartureTime(tStop.awaitDeparture);
            }
            NetworkRoute route = null;
            if (this.currentRouteProfile.firstLinkId != null) {
                if (this.currentRouteProfile.lastLinkId == null) {
                    this.currentRouteProfile.lastLinkId = this.currentRouteProfile.firstLinkId;
                }
                route = this.routeFactory.createRoute(NetworkRoute.class, this.currentRouteProfile.firstLinkId, this.currentRouteProfile.lastLinkId);
                route.setLinkIds(this.currentRouteProfile.firstLinkId, this.currentRouteProfile.linkIds, this.currentRouteProfile.lastLinkId);
            }
            TransitRoute transitRoute = this.schedule.getFactory().createTransitRoute(this.currentTransitRoute.id, route, stops, this.currentTransitRoute.mode);
            transitRoute.setDescription(this.currentTransitRoute.description);
            for (Departure departure : this.currentTransitRoute.departures.values()) {
                transitRoute.addDeparture(departure);
            }
            this.currentTransitLine.addRoute(transitRoute);
        }
    }

    private static class StringCache {
        private ConcurrentHashMap<String, String> cache = new ConcurrentHashMap(10000);

        private StringCache() {
        }

        public String get(String string) {
            if (string == null) {
                return null;
            }
            String s2 = this.cache.putIfAbsent(string, string);
            if (s2 == null) {
                return string;
            }
            return s2;
        }
    }

    private static class TempRoute {
        List<Id<Link>> linkIds = new ArrayList<Id<Link>>();
        Id<Link> firstLinkId = null;
        Id<Link> lastLinkId = null;

        protected TempRoute() {
        }

        protected void addLink(Id<Link> linkId) {
            if (this.firstLinkId == null) {
                this.firstLinkId = linkId;
            } else if (this.lastLinkId == null) {
                this.lastLinkId = linkId;
            } else {
                this.linkIds.add(this.lastLinkId);
                this.lastLinkId = linkId;
            }
        }
    }

    private static class TempStop {
        protected final TransitStopFacility stop;
        protected double departure = Double.NEGATIVE_INFINITY;
        protected double arrival = Double.NEGATIVE_INFINITY;
        protected boolean awaitDeparture = false;

        protected TempStop(TransitStopFacility stop) {
            this.stop = stop;
        }
    }

    private static class TempTransitRoute {
        protected final Id<TransitRoute> id;
        protected String description = null;
        protected Map<Id<Departure>, Departure> departures = new LinkedHashMap<Id<Departure>, Departure>();
        List<TempStop> stops = new ArrayList<TempStop>();
        String mode = null;

        protected TempTransitRoute(Id<TransitRoute> id) {
            this.id = id;
        }
    }
}

