/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class TransitScheduleWriterV1
extends MatsimXmlWriter
implements MatsimSomeWriter {
    private final CoordinateTransformation coordinateTransformation;
    private final TransitSchedule schedule;

    public TransitScheduleWriterV1(TransitSchedule schedule) {
        this(new IdentityTransformation(), schedule);
    }

    public TransitScheduleWriterV1(CoordinateTransformation coordinateTransformation, TransitSchedule schedule) {
        this.coordinateTransformation = coordinateTransformation;
        this.schedule = schedule;
    }

    public void write(String filename) throws UncheckedIOException {
        this.openFile(filename);
        this.writeXmlHead();
        this.writeDoctype("transitSchedule", "http://www.matsim.org/files/dtd/transitSchedule_v1.dtd");
        this.writeStartTag("transitSchedule", null);
        this.writeTransitStops();
        for (TransitLine line : this.schedule.getTransitLines().values()) {
            this.writeTransitLine(line);
        }
        this.writeEndTag("transitSchedule");
        this.close();
    }

    private void writeTransitStops() throws UncheckedIOException {
        this.writeStartTag("transitStops", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(5);
        for (TransitStopFacility stop : this.schedule.getFacilities().values()) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV1.createTuple("id", stop.getId().toString()));
            Coord coord = this.coordinateTransformation.transform(stop.getCoord());
            attributes.add(TransitScheduleWriterV1.createTuple("x", coord.getX()));
            attributes.add(TransitScheduleWriterV1.createTuple("y", coord.getY()));
            if (stop.getLinkId() != null) {
                attributes.add(TransitScheduleWriterV1.createTuple("linkRefId", stop.getLinkId().toString()));
            }
            if (stop.getName() != null) {
                attributes.add(TransitScheduleWriterV1.createTuple("name", stop.getName()));
            }
            attributes.add(TransitScheduleWriterV1.createTuple("isBlocking", stop.getIsBlockingLane()));
            this.writeStartTag("stopFacility", attributes, true);
        }
        this.writeEndTag("transitStops");
    }

    private void writeTransitLine(TransitLine line) throws UncheckedIOException {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
        attributes.add(TransitScheduleWriterV1.createTuple("id", line.getId().toString()));
        if (line.getName() != null) {
            attributes.add(TransitScheduleWriterV1.createTuple("name", line.getName()));
        }
        this.writeStartTag("transitLine", attributes);
        for (TransitRoute route : line.getRoutes().values()) {
            this.writeTransitRoute(route);
        }
        this.writeEndTag("transitLine");
    }

    private void writeTransitRoute(TransitRoute route) throws UncheckedIOException {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
        attributes.add(TransitScheduleWriterV1.createTuple("id", route.getId().toString()));
        this.writeStartTag("transitRoute", attributes);
        if (route.getDescription() != null) {
            this.writeStartTag("description", null);
            this.writeContent(route.getDescription(), false);
            this.writeEndTag("description");
        }
        this.writeStartTag("transportMode", null);
        this.writeContent(route.getTransportMode(), false);
        this.writeEndTag("transportMode");
        this.writeRouteProfile(route.getStops());
        this.writeRoute(route.getRoute());
        this.writeDepartures(route.getDepartures());
        this.writeEndTag("transitRoute");
    }

    private void writeRouteProfile(List<TransitRouteStop> stops) throws UncheckedIOException {
        this.writeStartTag("routeProfile", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(4);
        for (TransitRouteStop stop : stops) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV1.createTuple("refId", stop.getStopFacility().getId().toString()));
            if (stop.getArrivalOffset() != Double.NEGATIVE_INFINITY) {
                attributes.add(TransitScheduleWriterV1.createTimeTuple("arrivalOffset", stop.getArrivalOffset()));
            }
            if (stop.getDepartureOffset() != Double.NEGATIVE_INFINITY) {
                attributes.add(TransitScheduleWriterV1.createTimeTuple("departureOffset", stop.getDepartureOffset()));
            }
            attributes.add(TransitScheduleWriterV1.createTuple("awaitDeparture", String.valueOf(stop.isAwaitDepartureTime())));
            this.writeStartTag("stop", attributes, true);
        }
        this.writeEndTag("routeProfile");
    }

    private void writeRoute(NetworkRoute route) throws UncheckedIOException {
        if (route != null) {
            this.writeStartTag("route", null);
            ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
            attributes.add(TransitScheduleWriterV1.createTuple("refId", route.getStartLinkId().toString()));
            this.writeStartTag("link", attributes, true);
            for (Id<Link> linkId : route.getLinkIds()) {
                attributes.clear();
                attributes.add(TransitScheduleWriterV1.createTuple("refId", linkId.toString()));
                this.writeStartTag("link", attributes, true);
            }
            attributes.clear();
            attributes.add(TransitScheduleWriterV1.createTuple("refId", route.getEndLinkId().toString()));
            this.writeStartTag("link", attributes, true);
            this.writeEndTag("route");
        }
    }

    private void writeDepartures(Map<Id<Departure>, Departure> departures) throws UncheckedIOException {
        this.writeStartTag("departures", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(3);
        for (Departure dep : departures.values()) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV1.createTuple("id", dep.getId().toString()));
            attributes.add(TransitScheduleWriterV1.createTimeTuple("departureTime", dep.getDepartureTime()));
            if (dep.getVehicleId() != null) {
                attributes.add(TransitScheduleWriterV1.createTuple("vehicleRefId", dep.getVehicleId().toString()));
            }
            this.writeStartTag("departure", attributes, true);
        }
        this.writeEndTag("departures");
    }
}

