/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.MinimalTransferTimes;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.utils.objectattributes.attributable.AttributesUtils;
import org.matsim.utils.objectattributes.attributable.AttributesXmlWriterDelegate;

public class TransitScheduleWriterV2
extends MatsimXmlWriter
implements MatsimSomeWriter {
    private final CoordinateTransformation coordinateTransformation;
    private final TransitSchedule schedule;
    private final AttributesXmlWriterDelegate attributesWriter = new AttributesXmlWriterDelegate();

    public TransitScheduleWriterV2(TransitSchedule schedule) {
        this(new IdentityTransformation(), schedule);
    }

    public TransitScheduleWriterV2(CoordinateTransformation coordinateTransformation, TransitSchedule schedule) {
        this.coordinateTransformation = coordinateTransformation;
        this.schedule = schedule;
    }

    public void write(OutputStream stream) throws UncheckedIOException {
        this.openOutputStream(stream);
        try {
            this.writeData();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(String filename) throws UncheckedIOException {
        this.openFile(filename);
        try {
            this.writeData();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeData() throws IOException, UncheckedIOException {
        this.writeXmlHead();
        this.writeDoctype("transitSchedule", "http://www.matsim.org/files/dtd/transitSchedule_v2.dtd");
        this.writeStartTag("transitSchedule", null);
        this.writer.write("\n");
        this.attributesWriter.writeAttributes("\t", this.writer, this.schedule.getAttributes());
        this.writeTransitStops();
        this.writeMinimalTransferTimes();
        for (TransitLine line : this.schedule.getTransitLines().values()) {
            this.writeTransitLine(line);
        }
        this.writeEndTag("transitSchedule");
        this.close();
    }

    private void writeTransitStops() throws IOException, UncheckedIOException {
        this.writeStartTag("transitStops", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(5);
        for (TransitStopFacility stop : this.schedule.getFacilities().values()) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV2.createTuple("id", stop.getId().toString()));
            Coord coord = this.coordinateTransformation.transform(stop.getCoord());
            attributes.add(TransitScheduleWriterV2.createTuple("x", coord.getX()));
            attributes.add(TransitScheduleWriterV2.createTuple("y", coord.getY()));
            if (coord.hasZ()) {
                attributes.add(TransitScheduleWriterV2.createTuple("z", coord.getZ()));
            }
            if (stop.getLinkId() != null) {
                attributes.add(TransitScheduleWriterV2.createTuple("linkRefId", stop.getLinkId().toString()));
            }
            if (stop.getName() != null) {
                attributes.add(TransitScheduleWriterV2.createTuple("name", stop.getName()));
            }
            if (stop.getStopAreaId() != null) {
                attributes.add(TransitScheduleWriterV2.createTuple("stopAreaId", stop.getStopAreaId().toString()));
            }
            attributes.add(TransitScheduleWriterV2.createTuple("isBlocking", stop.getIsBlockingLane()));
            if (AttributesUtils.isEmpty(stop.getAttributes())) {
                this.writeStartTag("stopFacility", attributes, true);
                continue;
            }
            this.writeStartTag("stopFacility", attributes, false);
            if (!AttributesUtils.isEmpty(stop.getAttributes())) {
                this.writer.write("\n");
                this.attributesWriter.writeAttributes("\t\t\t", this.writer, stop.getAttributes());
            }
            this.writeEndTag("stopFacility");
        }
        this.writeEndTag("transitStops");
    }

    private void writeMinimalTransferTimes() {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(5);
        MinimalTransferTimes.MinimalTransferTimesIterator iter = this.schedule.getMinimalTransferTimes().iterator();
        if (iter.hasNext()) {
            this.writeStartTag("minimalTransferTimes", attributes);
            while (iter.hasNext()) {
                iter.next();
                attributes.clear();
                attributes.add(TransitScheduleWriterV2.createTuple("fromStop", iter.getFromStopId().toString()));
                attributes.add(TransitScheduleWriterV2.createTuple("toStop", iter.getToStopId().toString()));
                attributes.add(TransitScheduleWriterV2.createTuple("transferTime", iter.getSeconds()));
                this.writeStartTag("relation", attributes, true);
            }
            this.writeEndTag("minimalTransferTimes");
        }
    }

    private void writeTransitLine(TransitLine line) throws IOException, UncheckedIOException {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
        attributes.add(TransitScheduleWriterV2.createTuple("id", line.getId().toString()));
        if (line.getName() != null) {
            attributes.add(TransitScheduleWriterV2.createTuple("name", line.getName()));
        }
        this.writeStartTag("transitLine", attributes);
        if (!AttributesUtils.isEmpty(line.getAttributes())) {
            this.writer.write("\n");
            this.attributesWriter.writeAttributes("\t\t", this.writer, line.getAttributes());
        }
        for (TransitRoute route : line.getRoutes().values()) {
            this.writeTransitRoute(route);
        }
        this.writeEndTag("transitLine");
    }

    private void writeTransitRoute(TransitRoute route) throws IOException, UncheckedIOException {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
        attributes.add(TransitScheduleWriterV2.createTuple("id", route.getId().toString()));
        this.writeStartTag("transitRoute", attributes);
        if (!AttributesUtils.isEmpty(route.getAttributes())) {
            this.writer.write("\n");
            this.attributesWriter.writeAttributes("\t\t\t", this.writer, route.getAttributes());
        }
        if (route.getDescription() != null) {
            this.writeStartTag("description", null);
            this.writeContent(route.getDescription(), false);
            this.writeEndTag("description");
        }
        this.writeStartTag("transportMode", null);
        this.writeContent(route.getTransportMode(), false);
        this.writeEndTag("transportMode");
        this.writeRouteProfile(route.getStops());
        this.writeRoute(route.getRoute());
        this.writeDepartures(route.getDepartures());
        this.writeEndTag("transitRoute");
    }

    private void writeRouteProfile(List<TransitRouteStop> stops) throws UncheckedIOException {
        this.writeStartTag("routeProfile", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(4);
        for (TransitRouteStop stop : stops) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV2.createTuple("refId", stop.getStopFacility().getId().toString()));
            if (stop.getArrivalOffset() != Double.NEGATIVE_INFINITY) {
                attributes.add(TransitScheduleWriterV2.createTimeTuple("arrivalOffset", stop.getArrivalOffset()));
            }
            if (stop.getDepartureOffset() != Double.NEGATIVE_INFINITY) {
                attributes.add(TransitScheduleWriterV2.createTimeTuple("departureOffset", stop.getDepartureOffset()));
            }
            attributes.add(TransitScheduleWriterV2.createTuple("awaitDeparture", String.valueOf(stop.isAwaitDepartureTime())));
            this.writeStartTag("stop", attributes, true);
        }
        this.writeEndTag("routeProfile");
    }

    private void writeRoute(NetworkRoute route) throws UncheckedIOException {
        if (route != null) {
            this.writeStartTag("route", null);
            ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(1);
            attributes.add(TransitScheduleWriterV2.createTuple("refId", route.getStartLinkId().toString()));
            this.writeStartTag("link", attributes, true);
            for (Id<Link> linkId : route.getLinkIds()) {
                attributes.clear();
                attributes.add(TransitScheduleWriterV2.createTuple("refId", linkId.toString()));
                this.writeStartTag("link", attributes, true);
            }
            attributes.clear();
            attributes.add(TransitScheduleWriterV2.createTuple("refId", route.getEndLinkId().toString()));
            this.writeStartTag("link", attributes, true);
            this.writeEndTag("route");
        }
    }

    private void writeDepartures(Map<Id<Departure>, Departure> departures) throws IOException, UncheckedIOException {
        this.writeStartTag("departures", null);
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>(3);
        for (Departure dep : departures.values()) {
            attributes.clear();
            attributes.add(TransitScheduleWriterV2.createTuple("id", dep.getId().toString()));
            attributes.add(TransitScheduleWriterV2.createTimeTuple("departureTime", dep.getDepartureTime()));
            if (dep.getVehicleId() != null) {
                attributes.add(TransitScheduleWriterV2.createTuple("vehicleRefId", dep.getVehicleId().toString()));
            }
            if (AttributesUtils.isEmpty(dep.getAttributes())) {
                this.writeStartTag("departure", attributes, true);
                continue;
            }
            this.writeStartTag("departure", attributes, false);
            this.writer.write("\n");
            this.attributesWriter.writeAttributes("\t\t\t\t\t", this.writer, dep.getAttributes());
            this.writeEndTag("departure");
        }
        this.writeEndTag("departures");
    }
}

