/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule.api;

import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.scenario.ProjectionUtils;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.pt.transitSchedule.TransitScheduleReaderV1;
import org.matsim.pt.transitSchedule.TransitScheduleReaderV2;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TransitScheduleReader
implements MatsimReader {
    private final Scenario scenario;
    private final String externalInputCRS;
    private final String targetCRS;

    public TransitScheduleReader(String targetCRS, Scenario scenario) {
        this(null, targetCRS, scenario);
    }

    public TransitScheduleReader(String externalInputCRS, String targetCRS, Scenario scenario) {
        this.externalInputCRS = externalInputCRS;
        this.targetCRS = targetCRS;
        this.scenario = scenario;
    }

    public TransitScheduleReader(Scenario scenario) {
        this(null, null, scenario);
    }

    @Override
    public void readFile(String filename) throws UncheckedIOException {
        new XmlScheduleReader(this.externalInputCRS, this.targetCRS, this.scenario).readFile(filename);
    }

    @Override
    public void readURL(URL url) throws UncheckedIOException {
        new XmlScheduleReader(this.externalInputCRS, this.targetCRS, this.scenario).parse(url);
    }

    public void readStream(InputStream stream) throws UncheckedIOException {
        new XmlScheduleReader(this.externalInputCRS, this.targetCRS, this.scenario).parse(stream);
    }

    private static class XmlScheduleReader
    extends MatsimXmlParser {
        private MatsimXmlParser delegate = null;
        private final String externalInputCRS;
        private final String targetCRS;
        private final Scenario scenario;

        public XmlScheduleReader(String externalInputCRS, String targetCRS, Scenario scenario) {
            this.externalInputCRS = externalInputCRS;
            this.targetCRS = targetCRS;
            this.scenario = scenario;
        }

        @Override
        public void startTag(String name, Attributes atts, Stack<String> context) {
            this.delegate.startTag(name, atts, context);
        }

        @Override
        public void endTag(String name, String content, Stack<String> context) {
            this.delegate.endTag(name, content, context);
        }

        @Override
        protected void setDoctype(String doctype) {
            super.setDoctype(doctype);
            if ("transitSchedule_v2.dtd".equals(doctype)) {
                this.delegate = new TransitScheduleReaderV2(this.externalInputCRS, this.targetCRS, this.scenario);
            } else if ("transitSchedule_v1.dtd".equals(doctype)) {
                this.delegate = new TransitScheduleReaderV1(this.externalInputCRS != null ? TransformationFactory.getCoordinateTransformation(this.externalInputCRS, this.targetCRS) : new IdentityTransformation(), this.scenario);
            } else {
                throw new IllegalArgumentException("Unsupported doctype: " + doctype);
            }
        }

        @Override
        public void endDocument() {
            try {
                this.delegate.endDocument();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            if (this.targetCRS != null) {
                ProjectionUtils.putCRS(this.scenario.getTransitSchedule(), this.targetCRS);
            }
        }
    }
}

