/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.transitSchedule.api;

import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.pt.transitSchedule.TransitScheduleWriterV1;
import org.matsim.pt.transitSchedule.TransitScheduleWriterV2;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

public class TransitScheduleWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(TransitScheduleWriter.class);
    private final TransitSchedule schedule;
    private final CoordinateTransformation transformation;

    public TransitScheduleWriter(TransitSchedule schedule) {
        this(new IdentityTransformation(), schedule);
    }

    public TransitScheduleWriter(CoordinateTransformation transformation, TransitSchedule schedule) {
        this.transformation = transformation;
        this.schedule = schedule;
    }

    public void writeFile(String filename) throws UncheckedIOException {
        this.writeFileV2(filename);
    }

    public void writeFileV1(String filename) throws UncheckedIOException {
        log.info(Gbl.aboutToWrite("transit schedule", filename));
        new TransitScheduleWriterV1(this.transformation, this.schedule).write(filename);
    }

    public void writeFileV2(String filename) throws UncheckedIOException {
        log.info(Gbl.aboutToWrite("transit schedule", filename));
        new TransitScheduleWriterV2(this.transformation, this.schedule).write(filename);
    }
}

