/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopArea;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class CreatePseudoNetwork {
    private final TransitSchedule schedule;
    private final Network network;
    private final String prefix;
    private final double linkFreeSpeed;
    private final double linkCapacity;
    private final Map<Tuple<Node, Node>, Link> links = new HashMap<Tuple<Node, Node>, Link>();
    private final Map<Tuple<Node, Node>, TransitStopFacility> stopFacilities = new HashMap<Tuple<Node, Node>, TransitStopFacility>();
    private final Map<TransitStopFacility, Node> nodes = new HashMap<TransitStopFacility, Node>();
    private final Map<TransitStopFacility, List<TransitStopFacility>> facilityCopies = new HashMap<TransitStopFacility, List<TransitStopFacility>>();
    private long linkIdCounter = 0L;
    private final Set<String> transitModes = Collections.singleton("pt");

    public CreatePseudoNetwork(TransitSchedule schedule, Network network, String networkIdPrefix) {
        this.schedule = schedule;
        this.network = network;
        this.prefix = networkIdPrefix;
        this.linkFreeSpeed = 27.77777777777778;
        this.linkCapacity = 100000.0;
    }

    public CreatePseudoNetwork(TransitSchedule schedule, Network network, String networkIdPrefix, double linkFreeSpeed, double linkCapacity) {
        this.schedule = schedule;
        this.network = network;
        this.prefix = networkIdPrefix;
        this.linkFreeSpeed = linkFreeSpeed;
        this.linkCapacity = linkCapacity;
    }

    public void createNetwork() {
        LinkedList<Tuple<TransitLine, TransitRoute>> toBeRemoved = new LinkedList<Tuple<TransitLine, TransitRoute>>();
        for (TransitLine transitLine : this.schedule.getTransitLines().values()) {
            for (TransitRoute tRoute : transitLine.getRoutes().values()) {
                ArrayList<Id<Link>> routeLinks = new ArrayList<Id<Link>>();
                TransitRouteStop prevStop = null;
                for (TransitRouteStop stop : tRoute.getStops()) {
                    Link link = this.getNetworkLink(prevStop, stop);
                    routeLinks.add(link.getId());
                    prevStop = stop;
                }
                if (routeLinks.size() > 0) {
                    NetworkRoute route = RouteUtils.createNetworkRoute(routeLinks, this.network);
                    tRoute.setRoute(route);
                    continue;
                }
                System.err.println("Line " + transitLine.getId() + " route " + tRoute.getId() + " has less than two stops. Removing this route from schedule.");
                toBeRemoved.add(new Tuple<TransitLine, TransitRoute>(transitLine, tRoute));
            }
        }
        for (Tuple tuple : toBeRemoved) {
            ((TransitLine)tuple.getFirst()).removeRoute((TransitRoute)tuple.getSecond());
        }
    }

    private Link getNetworkLink(TransitRouteStop fromStop, TransitRouteStop toStop) {
        Tuple<Node, Node> connection;
        Link link;
        Node toNode;
        TransitStopFacility fromFacility = fromStop == null ? toStop.getStopFacility() : fromStop.getStopFacility();
        TransitStopFacility toFacility = toStop.getStopFacility();
        Node fromNode = this.nodes.get(fromFacility);
        if (fromNode == null) {
            fromNode = this.network.getFactory().createNode(Id.create(this.prefix + toFacility.getId(), Node.class), fromFacility.getCoord());
            this.network.addNode(fromNode);
            this.nodes.put(toFacility, fromNode);
        }
        if ((toNode = this.nodes.get(toFacility)) == null) {
            toNode = this.network.getFactory().createNode(Id.create(this.prefix + toFacility.getId(), Node.class), toFacility.getCoord());
            this.network.addNode(toNode);
            this.nodes.put(toFacility, toNode);
        }
        if ((link = this.links.get(connection = new Tuple<Node, Node>(fromNode, toNode))) == null) {
            link = this.createAndAddLink(fromNode, toNode, connection);
            if (toFacility.getLinkId() == null) {
                toFacility.setLinkId(link.getId());
                this.stopFacilities.put(connection, toFacility);
            } else {
                List<TransitStopFacility> copies = this.facilityCopies.get(toFacility);
                if (copies == null) {
                    copies = new ArrayList<TransitStopFacility>();
                    this.facilityCopies.put(toFacility, copies);
                }
                Id<TransitStopFacility> newId = Id.create(toFacility.getId().toString() + "." + Integer.toString(copies.size() + 1), TransitStopFacility.class);
                TransitStopFacility newFacility = this.schedule.getFactory().createTransitStopFacility(newId, toFacility.getCoord(), toFacility.getIsBlockingLane());
                newFacility.setStopAreaId(Id.create(toFacility.getId(), TransitStopArea.class));
                newFacility.setLinkId(link.getId());
                newFacility.setName(toFacility.getName());
                copies.add(newFacility);
                this.nodes.put(newFacility, toNode);
                this.schedule.addStopFacility(newFacility);
                toStop.setStopFacility(newFacility);
                this.stopFacilities.put(connection, newFacility);
            }
        } else {
            toStop.setStopFacility(this.stopFacilities.get(connection));
        }
        return link;
    }

    private Link createAndAddLink(Node fromNode, Node toNode, Tuple<Node, Node> connection) {
        Link link = this.network.getFactory().createLink(Id.create(this.prefix + this.linkIdCounter++, Link.class), fromNode, toNode);
        if (fromNode == toNode) {
            link.setLength(50.0);
        } else {
            link.setLength(CoordUtils.calcEuclideanDistance(fromNode.getCoord(), toNode.getCoord()));
        }
        link.setFreespeed(this.linkFreeSpeed);
        link.setCapacity(this.linkCapacity);
        link.setNumberOfLanes(1.0);
        this.network.addLink(link);
        link.setAllowedModes(this.transitModes);
        this.links.put(connection, link);
        return link;
    }

    public Link getLinkBetweenStops(TransitStopFacility fromStop, TransitStopFacility toStop) {
        Node fromNode = this.nodes.get(fromStop);
        Node toNode = this.nodes.get(toStop);
        Tuple<Node, Node> connection = new Tuple<Node, Node>(fromNode, toNode);
        return this.links.get(connection);
    }
}

