/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.utils;

import org.matsim.api.core.v01.Id;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleCapacityImpl;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.Vehicles;
import org.matsim.vehicles.VehiclesFactory;

public class CreateVehiclesForSchedule {
    private final TransitSchedule schedule;
    private final Vehicles vehicles;

    public CreateVehiclesForSchedule(TransitSchedule schedule, Vehicles vehicles) {
        this.schedule = schedule;
        this.vehicles = vehicles;
    }

    public void run() {
        VehiclesFactory vb = this.vehicles.getFactory();
        VehicleType vehicleType = vb.createVehicleType(Id.create("defaultTransitVehicleType", VehicleType.class));
        VehicleCapacityImpl capacity = new VehicleCapacityImpl();
        capacity.setSeats(101);
        capacity.setStandingRoom(0);
        vehicleType.setCapacity(capacity);
        this.vehicles.addVehicleType(vehicleType);
        long vehId = 0L;
        for (TransitLine line : this.schedule.getTransitLines().values()) {
            for (TransitRoute route : line.getRoutes().values()) {
                for (Departure departure : route.getDepartures().values()) {
                    Vehicle veh = vb.createVehicle(Id.create("tr_" + Long.toString(vehId++), Vehicle.class), vehicleType);
                    this.vehicles.addVehicle(veh);
                    departure.setVehicleId(veh.getId());
                }
            }
        }
    }
}

