/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.PopulationReader;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.households.Households;
import org.matsim.lanes.Lanes;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.vehicles.Vehicles;

public class CreateSelectedPlansTables {
    private Population plans0;
    private Population plans1;
    private static final String outfileTable = "./output/analyseSelectedPlansTable.txt";
    private static final String outfileAverages = "./output/analyseSelectedPlansTableAverages.txt";
    private boolean twoPlans;
    private MutableScenario scenario;
    private final double[] sumPlanTraveltime = new double[]{0.0, 0.0};
    private final double[] sumPlanTraveldistance = new double[]{0.0, 0.0};
    private final double[] sumLegTraveltime = new double[]{0.0, 0.0};
    private final double[] sumLegTraveldistance = new double[]{0.0, 0.0};
    private final int[] sumNrLegs = new int[]{0, 0};

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Too few arguments.");
            CreateSelectedPlansTables.printUsage();
            System.exit(1);
        }
        Gbl.startMeasurement();
        CreateSelectedPlansTables table = new CreateSelectedPlansTables();
        if (args.length == 3) {
            table.setTwoPlans(true);
            table.run(args[0], args[1], args[2]);
        } else {
            table.setTwoPlans(false);
            table.run(args[0], args[1], "");
        }
        Gbl.printElapsedTime();
    }

    private void init(String networkPath) {
        this.scenario = (MutableScenario)ScenarioUtils.createScenario(ConfigUtils.createConfig());
        this.plans0 = ScenarioUtils.createScenario(ConfigUtils.createConfig()).getPopulation();
        this.plans1 = ScenarioUtils.createScenario(ConfigUtils.createConfig()).getPopulation();
        System.out.println("  reading the network...");
        new MatsimNetworkReader(this.scenario.getNetwork()).readFile(networkPath);
    }

    private void readPlansFile(String plansfilePath, Population plans) {
        System.out.println("  reading file " + plansfilePath);
        PopulationReader plansReader = new PopulationReader(new PseudoScenario(this.scenario, plans));
        plansReader.readFile(plansfilePath);
    }

    private void writeAvgFile() {
        try {
            String header = "plansfile_nr\tplantraveltime\tplantraveldistance\tlegtraveltime\tlegtraveldistance\tnumberoflegs";
            BufferedWriter out = IOUtils.getBufferedWriter(outfileAverages);
            out.write("plansfile_nr\tplantraveltime\tplantraveldistance\tlegtraveltime\tlegtraveldistance\tnumberoflegs");
            out.write(10);
            int nr_selectedplans = this.plans0.getPersons().size();
            int i_max = 1;
            if (this.twoPlans) {
                i_max = 2;
            }
            for (int i = 0; i < i_max; ++i) {
                out.write(i + "\t");
                out.write(this.sumPlanTraveltime[i] / (double)nr_selectedplans + "\t");
                out.write(this.sumPlanTraveldistance[i] / (double)nr_selectedplans + "\t");
                out.write(this.sumLegTraveltime[i] / (double)nr_selectedplans + "\t");
                out.write(this.sumLegTraveldistance[i] / (double)nr_selectedplans + "\t");
                out.write(this.sumNrLegs[i] / nr_selectedplans + "\t");
                out.write(10);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSummaryFile() {
        try {
            String header = "personid\tsex\tage\tlicense\tcaravail\temployed\thomex\thomey\thomelink\tscore0\tplantraveltime0\tplantraveldistance0\tnumberoftrips0\t";
            if (this.twoPlans) {
                header = header.concat("score1\tplantraveltime1\tplantraveldistance1\tnumberoftrips1");
            }
            BufferedWriter out = IOUtils.getBufferedWriter(outfileTable);
            out.write(header);
            out.write(10);
            for (Id<Person> person_id : this.plans0.getPersons().keySet()) {
                Plan selectedPlan;
                out.write(person_id.toString() + "\t");
                Person person = this.plans0.getPersons().get(person_id);
                out.write(PersonUtils.getSex(person) + "\t");
                out.write(PersonUtils.getAge(person) + "\t");
                out.write(PersonUtils.getLicense(person) + "\t");
                out.write(PersonUtils.getCarAvail(person) + "\t");
                if (PersonUtils.isEmployed(person) != null) {
                    out.write(PersonUtils.isEmployed(person) != false ? "yes" : "no");
                }
                out.write("\t");
                Plan selectedPlanImpl = selectedPlan = (Plan)person.getSelectedPlan();
                Activity firstActivity = PopulationUtils.getFirstActivity(selectedPlanImpl);
                Coord c = null;
                String link_id = "-";
                if (firstActivity.getType().substring(0, 1).equals("h")) {
                    c = firstActivity.getCoord();
                    link_id = firstActivity.getLinkId().toString();
                }
                if (c != null) {
                    out.write(c.getX() + "\t");
                    out.write(c.getY() + "\t");
                } else {
                    out.write("-\t-\t");
                }
                out.write(link_id + "\t");
                out.write(selectedPlan.getScore() + "\t");
                out.write(this.getTravelTime(person) + "\t");
                this.sumPlanTraveltime[0] = this.sumPlanTraveltime[0] + this.getTravelTime(person);
                out.write(this.getTravelDist(person) + "\t");
                this.sumPlanTraveldistance[0] = this.sumPlanTraveldistance[0] + this.getTravelDist(person);
                out.write(this.getNumberOfTrips(person) + "\t");
                this.sumNrLegs[0] = this.sumNrLegs[0] + this.getNumberOfTrips(person);
                this.sumLegTraveltime[0] = this.sumLegTraveltime[0] + this.getTravelTime(person) / (double)this.getNumberOfTrips(person);
                this.sumLegTraveldistance[0] = this.sumLegTraveldistance[0] + this.getTravelDist(person) / (double)this.getNumberOfTrips(person);
                if (this.twoPlans) {
                    Person person_comp = this.plans1.getPersons().get(person_id);
                    out.write(((Plan)person_comp.getSelectedPlan()).getScore() + "\t");
                    out.write(this.getTravelTime(person_comp) + "\t");
                    this.sumPlanTraveltime[1] = this.sumPlanTraveltime[1] + this.getTravelTime(person_comp);
                    out.write(this.getTravelDist(person_comp) + "\t");
                    this.sumPlanTraveldistance[1] = this.sumPlanTraveldistance[1] + this.getTravelDist(person_comp);
                    out.write(this.getNumberOfTrips(person_comp) + "\t");
                    this.sumNrLegs[1] = this.sumNrLegs[1] + this.getNumberOfTrips(person_comp);
                    this.sumLegTraveltime[1] = this.sumLegTraveltime[1] + this.getTravelTime(person_comp) / (double)this.getNumberOfTrips(person_comp);
                    this.sumLegTraveldistance[1] = this.sumLegTraveldistance[1] + this.getTravelDist(person_comp) / (double)this.getNumberOfTrips(person_comp);
                }
                out.write(10);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double getTravelTime(Person person) {
        double travelTime = 0.0;
        for (PlanElement pe : ((Plan)person.getSelectedPlan()).getPlanElements()) {
            if (!(pe instanceof Leg)) continue;
            travelTime += ((Leg)pe).getTravelTime();
        }
        return travelTime;
    }

    private double getTravelDist(Person person) {
        double travelDist = 0.0;
        for (PlanElement pe : ((Plan)person.getSelectedPlan()).getPlanElements()) {
            if (!(pe instanceof Leg)) continue;
            travelDist += ((Leg)pe).getRoute().getDistance();
        }
        return travelDist;
    }

    private int getNumberOfTrips(Person person) {
        int numberOfLegs = 0;
        for (PlanElement pe : ((Plan)person.getSelectedPlan()).getPlanElements()) {
            if (!(pe instanceof Leg)) continue;
            ++numberOfLegs;
        }
        return numberOfLegs;
    }

    private void run(String networkPath, String plansfilePath0, String plansfilePath1) {
        this.init(networkPath);
        this.readPlansFile(plansfilePath0, this.plans0);
        System.out.println(this.twoPlans);
        if (this.twoPlans) {
            this.readPlansFile(plansfilePath1, this.plans1);
        }
        this.writeSummaryFile();
        this.writeAvgFile();
        System.out.println("finished");
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("CreateSelectedPlansTables:");
        System.out.println();
        System.out.println("Creates an agent-based table including all agent \nattributes, the selected plan score and the plan and \nleg travel times and distances and \nanother table containing the aggregated values.");
        System.out.println();
        System.out.println("usage: CompareSelectedPlansTable args");
        System.out.println(" arg 0: path to network file (required)");
        System.out.println(" arg 1: path to plans file 0 (required)");
        System.out.println(" arg 2: path to plans file 1 (optional)");
        System.out.println("----------------");
        System.out.println("2008, matsim.org");
        System.out.println();
    }

    public void setTwoPlans(boolean twoPlans) {
        this.twoPlans = twoPlans;
    }

    private static class PseudoScenario
    implements Scenario {
        private final Scenario scenario;
        private final Population myPopulation;

        public PseudoScenario(Scenario scenario, Population population) {
            this.scenario = scenario;
            this.myPopulation = population;
        }

        @Override
        public Population getPopulation() {
            return this.myPopulation;
        }

        public Coord createCoord(double x, double y) {
            return new Coord(x, y);
        }

        @Override
        public Config getConfig() {
            return this.scenario.getConfig();
        }

        @Override
        public Network getNetwork() {
            return this.scenario.getNetwork();
        }

        @Override
        public ActivityFacilities getActivityFacilities() {
            return this.scenario.getActivityFacilities();
        }

        @Override
        public TransitSchedule getTransitSchedule() {
            return this.scenario.getTransitSchedule();
        }

        @Override
        public void addScenarioElement(String name, Object o) {
            this.scenario.addScenarioElement(name, o);
        }

        @Override
        public Object getScenarioElement(String name) {
            return this.scenario.getScenarioElement(name);
        }

        @Override
        public Vehicles getTransitVehicles() {
            return this.scenario.getTransitVehicles();
        }

        @Override
        public Households getHouseholds() {
            return this.scenario.getHouseholds();
        }

        @Override
        public Lanes getLanes() {
            return this.scenario.getLanes();
        }

        @Override
        public Vehicles getVehicles() {
            return this.scenario.getVehicles();
        }
    }
}

