/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import java.io.File;
import java.util.Collection;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.events.EventsUtils;
import org.matsim.core.events.MatsimEventsReader;
import org.matsim.core.events.algorithms.SnapshotGenerator;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.misc.ArgumentParser;
import org.matsim.vis.snapshotwriters.KmlSnapshotWriter;
import org.matsim.vis.snapshotwriters.SnapshotWriter;
import org.matsim.vis.snapshotwriters.TransimsSnapshotWriter;

public class Events2Snapshot {
    private Config config = null;
    private Network network = null;
    private EventsManager events = null;
    private SnapshotGenerator visualizer = null;
    private String configfile = null;
    private String eventsfile;
    private SnapshotWriter writer = null;

    private void parseArguments(String[] args) {
        if (args.length == 0) {
            System.out.println("Too few arguments.");
            this.printUsage();
            System.exit(1);
        }
        for (String arg : new ArgumentParser(args)) {
            if (arg.equals("-h") || arg.equals("--help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.contains(".xml")) {
                this.configfile = arg;
                continue;
            }
            if (arg.contains("events")) {
                this.eventsfile = arg;
                continue;
            }
            System.out.println("Unrecognized file \"" + arg + "\"");
            this.printUsage();
            System.exit(1);
        }
    }

    private void printUsage() {
        System.out.println();
        System.out.println("Events2Snapshot");
        System.out.println("Converts an events file to a snapshot file.");
        System.out.println();
        System.out.println("usage: Events2Snapshot [OPTIONS] configfile [eventsfile]");
        System.out.println("       If no eventsfile is given, the in-events-file specified in the config-");
        System.out.println("       file will be used.");
        System.out.println("       The snapshots are generated according to the snapshot-settings in the");
        System.out.println("       simulation-part of the configuration.");
        System.out.println();
        System.out.println("Options:");
        System.out.println("-h, --help:     Displays this message.");
        System.out.println();
        System.out.println("----------------");
        System.out.println("2007, matsim.org");
        System.out.println();
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.config = ConfigUtils.loadConfig(this.configfile, new ConfigGroup[0]);
        MatsimRandom.reset(this.config.global().getRandomSeed());
        Scenario scenario = ScenarioUtils.createScenario(this.config);
        this.network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile(this.config.network().getInputFile());
        this.prepare();
        if (this.eventsfile == null) {
            this.eventsfile = this.config.getParam("events", "inputFile");
        }
        System.out.println("reading events from " + this.eventsfile);
        File file = new File(this.eventsfile);
        String outputDir = file.getParent() + "/";
        this.loadSnapshotWriters(outputDir);
        new MatsimEventsReader(this.events).readFile(this.eventsfile);
        this.visualizer.finish();
        System.out.println("done.");
    }

    public void run(File eventsFile, Config config, Network network) {
        this.eventsfile = eventsFile.getAbsolutePath();
        this.config = config;
        if (this.config.qsim().getSnapshotPeriod() <= 0.0) {
            System.out.println("The snapshotPeriod must be larger than 0 seconds.");
            return;
        }
        this.network = network;
        this.prepare();
        if (this.eventsfile == null) {
            this.eventsfile = this.config.getParam("events", "inputFile");
        }
        System.out.println("reading events from " + this.eventsfile);
        File file = new File(this.eventsfile);
        String outputDir = file.getParent() + "/";
        this.loadSnapshotWriters(outputDir);
        try {
            new MatsimEventsReader(this.events).readFile(this.eventsfile);
        }
        catch (OutOfMemoryError e) {
            System.err.println("OutOfMemoryError while reading all events:");
            e.printStackTrace();
            System.err.println("Trying to close visualizer file up to this state, it may not be complete though.");
        }
        this.visualizer.finish();
        System.out.println("done.");
    }

    private void prepare() {
        this.events = EventsUtils.createEventsManager();
        this.visualizer = new SnapshotGenerator(this.network, this.config.qsim().getSnapshotPeriod(), this.config.qsim());
        this.events.addHandler(this.visualizer);
    }

    public void addExternalSnapshotWriter(SnapshotWriter writer) {
        this.writer = writer;
    }

    private void loadSnapshotWriters(String outputDir) {
        String snapshotFile;
        Collection<String> snapshotFormat;
        if (this.writer != null) {
            this.visualizer.addSnapshotWriter(this.writer);
        }
        if ((snapshotFormat = this.config.controler().getSnapshotFormat()).contains("transims")) {
            snapshotFile = outputDir + "T.veh";
            this.visualizer.addSnapshotWriter(new TransimsSnapshotWriter(snapshotFile));
        }
        if (snapshotFormat.contains("googleearth")) {
            snapshotFile = outputDir + "googleearth.kmz";
            String coordSystem = this.config.global().getCoordinateSystem();
            this.visualizer.addSnapshotWriter(new KmlSnapshotWriter(snapshotFile, TransformationFactory.getCoordinateTransformation(coordSystem, "WGS84")));
        }
    }

    public static void main(String[] args) {
        new Events2Snapshot().run(args);
    }
}

