/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Iterator;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.population.io.StreamingPopulationWriter;
import org.matsim.core.router.PlanRouter;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripRouterModule;
import org.matsim.core.router.costcalculators.FreespeedTravelTimeAndDisutility;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioByInstanceModule;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.misc.ArgumentParser;

public class InitRoutes {
    private Config config;
    private String configfile = null;
    private String plansfile = null;

    private void parseArguments(String[] args) {
        Iterator<String> argIter;
        String arg;
        if (args.length == 0) {
            System.out.println("Too few arguments.");
            this.printUsage();
            System.exit(1);
        }
        if ((arg = (argIter = new ArgumentParser(args).iterator()).next()).equals("-h") || arg.equals("--help")) {
            this.printUsage();
            System.exit(0);
        } else {
            this.configfile = arg;
            this.plansfile = argIter.next();
            if (argIter.hasNext()) {
                System.out.println("Too many arguments.");
                this.printUsage();
                System.exit(1);
            }
        }
    }

    private void printUsage() {
        System.out.println();
        System.out.println("InitRoutes");
        System.out.println("Reads a plans-file and assignes each leg in each plan of each person");
        System.out.println("a an initial route (freespeed) based on the given netowrk. The modified plans/");
        System.out.println("persons are then written out to file again.");
        System.out.println();
        System.out.println("usage: InitRoutes [OPTIONS] configfile");
        System.out.println("       The following parameters must be given in the config-file:");
        System.out.println("       - network.inputNetworkFile");
        System.out.println("       - plans.inputPlansFile");
        System.out.println("       - plans.outputPlansFile");
        System.out.println();
        System.out.println("Options:");
        System.out.println("-h, --help:     Displays this message.");
        System.out.println();
        System.out.println("----------------");
        System.out.println("2008, matsim.org");
        System.out.println();
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.config = ConfigUtils.loadConfig(this.configfile, new ConfigGroup[0]);
        MatsimRandom.reset(this.config.global().getRandomSeed());
        final MutableScenario scenario = ScenarioUtils.createMutableScenario(this.config);
        StreamingPopulationReader reader = new StreamingPopulationReader(scenario);
        new MatsimNetworkReader(scenario.getNetwork()).readFile(this.config.network().getInputFile());
        StreamingPopulationWriter plansWriter = new StreamingPopulationWriter();
        Gbl.assertNotNull(this.plansfile);
        plansWriter.startStreaming(this.plansfile);
        final FreespeedTravelTimeAndDisutility timeCostCalc = new FreespeedTravelTimeAndDisutility(this.config.planCalcScore());
        Injector injector = org.matsim.core.controler.Injector.createInjector(scenario.getConfig(), new AbstractModule(){

            @Override
            public void install() {
                this.install(AbstractModule.override(Arrays.asList(new TripRouterModule()), new AbstractModule(){

                    @Override
                    public void install() {
                        this.install(new ScenarioByInstanceModule(scenario));
                        this.addTravelTimeBinding("car").toInstance(timeCostCalc);
                        this.addTravelDisutilityFactoryBinding("car").toInstance(new TravelDisutilityFactory(){

                            @Override
                            public TravelDisutility createTravelDisutility(TravelTime timeCalculator) {
                                return timeCostCalc;
                            }
                        });
                    }
                }));
            }
        });
        reader.addAlgorithm(new PlanRouter(injector.getInstance(TripRouter.class), null));
        reader.addAlgorithm(plansWriter);
        reader.readFile(this.config.plans().getInputFile());
        PopulationUtils.printPlansCount(reader);
        plansWriter.closeStreaming();
        System.out.println("done.");
    }

    public static void main(String[] args) {
        new InitRoutes().run(args);
    }
}

