/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import java.util.Iterator;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.network.io.NetworkWriter;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.misc.ArgumentParser;

public class NetworkCleaner {
    private void printUsage() {
        System.out.println();
        System.out.println("NetworkCleaner");
        System.out.println("Reads a network-file and \"cleans\" it. Currently, it performs the following");
        System.out.println("steps to ensure a network is suited for simulation:");
        System.out.println(" - ensure every link can be reached by every other link. It looks for the");
        System.out.println("   biggest cluster of connected nodes and links and removes all other elements.");
        System.out.println();
        System.out.println("usage: NetworkCleaner [OPTIONS] input-network-file output-network-file");
        System.out.println();
        System.out.println("Options:");
        System.out.println("-h, --help:     Displays this message.");
        System.out.println();
        System.out.println("----------------");
        System.out.println("2008, matsim.org");
        System.out.println();
    }

    public void run(String inputNetworkFile, String outputNetworkFile) {
        Scenario scenario = ScenarioUtils.createScenario(ConfigUtils.createConfig());
        Network network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile(inputNetworkFile);
        new org.matsim.core.network.algorithms.NetworkCleaner().run(network);
        new NetworkWriter(network).write(outputNetworkFile);
    }

    public void run(String[] args) {
        Iterator<String> argIter;
        String arg;
        if (args.length == 0) {
            System.out.println("Too few arguments.");
            this.printUsage();
            System.exit(1);
        }
        if ((arg = (argIter = new ArgumentParser(args).iterator()).next()).equals("-h") || arg.equals("--help")) {
            this.printUsage();
            System.exit(0);
        } else {
            String inputFile = arg;
            if (!argIter.hasNext()) {
                System.out.println("Too few arguments.");
                this.printUsage();
                System.exit(1);
            }
            String outputFile = argIter.next();
            if (argIter.hasNext()) {
                System.out.println("Too many arguments.");
                this.printUsage();
                System.exit(1);
            }
            this.run(inputFile, outputFile);
        }
    }

    public static void main(String[] args) {
        new NetworkCleaner().run(args);
    }
}

