/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.misc.Time;

final class OldToNewPlanCalcScoreConfigGroup
extends ConfigGroup {
    private static final Logger log = Logger.getLogger(OldToNewPlanCalcScoreConfigGroup.class);
    public static final String GROUP_NAME = "planCalcScore";
    private static final String LEARNING_RATE = "learningRate";
    private static final String BRAIN_EXP_BETA = "BrainExpBeta";
    private static final String PATH_SIZE_LOGIT_BETA = "PathSizeLogitBeta";
    private static final String LATE_ARRIVAL = "lateArrival";
    private static final String EARLY_DEPARTURE = "earlyDeparture";
    private static final String PERFORMING = "performing";
    private static final String TRAVELING = "traveling_";
    private static final String TRAVELING_CAR = "traveling";
    private static final String TRAVELING_PT = "travelingPt";
    private static final String TRAVELING_BIKE = "travelingBike";
    private static final String TRAVELING_WALK = "travelingWalk";
    private static final String TRAVELING_OTHER = "travelingOther";
    private static final String WAITING = "waiting";
    private static final String WAITING_PT = "waitingPt";
    private static final String CONSTANT = "constant_";
    private static final String CONSTANT_CAR = "constantCar";
    private static final String CONSTANT_BIKE = "constantBike";
    private static final String CONSTANT_WALK = "constantWalk";
    private static final String CONSTANT_OTHER = "constantOther";
    private static final String CONSTANT_PT = "constantPt";
    private static final String WRITE_EXPERIENCED_PLANS = "writeExperiencedPlans";
    private static final String MARGINAL_UTL_OF_DISTANCE_CAR = "marginalUtlOfDistanceCar";
    private static final String MARGINAL_UTL_OF_DISTANCE_PT = "marginalUtlOfDistancePt";
    private static final String MARGINAL_UTL_OF_DISTANCE = "marginalUtlOfDistance_";
    private static final String MARGINAL_UTL_OF_DISTANCE_WALK = "marginalUtlOfDistanceWalk";
    private static final String MARGINAL_UTL_OF_DISTANCE_OTHER = "marginalUtlOfDistanceOther";
    private static final String MARGINAL_UTL_OF_MONEY = "marginalUtilityOfMoney";
    @Deprecated
    private static final String MONETARY_DISTANCE_COST_RATE = "monetaryDistanceCostRate";
    private static final String MONETARY_DISTANCE_RATE_ = "monetaryDistanceRate_";
    private static final Object MONETARY_DISTANCE_RATE_CAR = "monetaryDistanceRateCar";
    private static final Object MONETARY_DISTANCE_RATE_PT = "monetaryDistanceRatePt";
    private static final String UTL_OF_LINE_SWITCH = "utilityOfLineSwitch";
    private static final String ACTIVITY_TYPE = "activityType_";
    private static final String ACTIVITY_PRIORITY = "activityPriority_";
    private static final String ACTIVITY_TYPICAL_DURATION = "activityTypicalDuration_";
    private static final String ACTIVITY_MINIMAL_DURATION = "activityMinimalDuration_";
    private static final String ACTIVITY_OPENING_TIME = "activityOpeningTime_";
    private static final String ACTIVITY_LATEST_START_TIME = "activityLatestStartTime_";
    private static final String ACTIVITY_EARLIEST_END_TIME = "activityEarliestEndTime_";
    private static final String ACTIVITY_CLOSING_TIME = "activityClosingTime_";
    private static final String SCORING_THIS_ACTIVITY_AT_ALL = "scoringThisActivityAtAll_";
    private final ReflectiveDelegate delegate = new ReflectiveDelegate();
    private final Map<String, ActivityParams> activityTypesByNumber = new HashMap<String, ActivityParams>();
    private Double waitingPt = null;
    private static final String USING_OLD_SCORING_BELOW_ZERO_UTILITY_DURATION = "usingOldScoringBelowZeroUtilityDuration";
    private boolean memorizingExperiencedPlans = false;
    public static final String EXPERIENCED_PLAN_KEY = "experiencedPlan";
    private static final String FRACTION_OF_ITERATIONS_TO_START_SCORE_MSA = "fractionOfIterationsToStartScoreMSA";

    public OldToNewPlanCalcScoreConfigGroup() {
        super(GROUP_NAME);
        this.addParameterSet(new ModeParams("car"));
        this.addParameterSet(new ModeParams("pt"));
        this.addParameterSet(new ModeParams("walk"));
        this.addParameterSet(new ModeParams("bike"));
        this.addParameterSet(new ModeParams("other"));
    }

    @Override
    public String getValue(String key) {
        throw new IllegalArgumentException(key + ": getValue access disabled; use direct getter");
    }

    @Override
    public void addParam(String key, String value) {
        if (key.startsWith(ACTIVITY_TYPE)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_TYPE.length()), true);
            actParams.setActivityType(value);
            this.removeParameterSet(actParams);
            this.addActivityParams(actParams);
        } else if (key.startsWith(ACTIVITY_PRIORITY)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_PRIORITY.length()), true);
            actParams.setPriority(Double.parseDouble(value));
        } else if (key.startsWith(ACTIVITY_TYPICAL_DURATION)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_TYPICAL_DURATION.length()), true);
            actParams.setTypicalDuration(Time.parseTime(value));
        } else if (key.startsWith(ACTIVITY_MINIMAL_DURATION)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_MINIMAL_DURATION.length()), true);
            actParams.setMinimalDuration(Time.parseTime(value));
        } else if (key.startsWith(ACTIVITY_OPENING_TIME)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_OPENING_TIME.length()), true);
            actParams.setOpeningTime(Time.parseTime(value));
        } else if (key.startsWith(ACTIVITY_LATEST_START_TIME)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_LATEST_START_TIME.length()), true);
            actParams.setLatestStartTime(Time.parseTime(value));
        } else if (key.startsWith(ACTIVITY_EARLIEST_END_TIME)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_EARLIEST_END_TIME.length()), true);
            actParams.setEarliestEndTime(Time.parseTime(value));
        } else if (key.startsWith(ACTIVITY_CLOSING_TIME)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(ACTIVITY_CLOSING_TIME.length()), true);
            actParams.setClosingTime(Time.parseTime(value));
        } else if (key.startsWith(SCORING_THIS_ACTIVITY_AT_ALL)) {
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring(SCORING_THIS_ACTIVITY_AT_ALL.length()), true);
            actParams.setScoringThisActivityAtAll(Boolean.parseBoolean(value));
        } else if (key.startsWith(TRAVELING)) {
            ModeParams modeParams = this.getOrCreateModeParams(key.substring(TRAVELING.length()));
            modeParams.setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if (key.startsWith(MARGINAL_UTL_OF_DISTANCE)) {
            ModeParams modeParams = this.getOrCreateModeParams(key.substring(MARGINAL_UTL_OF_DISTANCE.length()));
            modeParams.setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else {
            if (key.startsWith(MONETARY_DISTANCE_COST_RATE)) {
                throw new RuntimeException("Please use monetaryDistanceRate (without `cost').  Even better, use config v2, mode-parameters (see output of any recent run), and mode-specific monetary distance rate.");
            }
            if (key.startsWith(MONETARY_DISTANCE_RATE_)) {
                ModeParams modeParams = this.getOrCreateModeParams(key.substring(MONETARY_DISTANCE_RATE_.length()));
                modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
            } else if (MONETARY_DISTANCE_RATE_CAR.equals(key)) {
                ModeParams modeParams = this.getOrCreateModeParams("car");
                modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
            } else if (MONETARY_DISTANCE_RATE_PT.equals(key)) {
                ModeParams modeParams = this.getOrCreateModeParams("pt");
                modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
            } else if (key.startsWith(CONSTANT)) {
                ModeParams modeParams = this.getOrCreateModeParams(key.substring(CONSTANT.length()));
                modeParams.setConstant(Double.parseDouble(value));
            } else if (TRAVELING_CAR.equals(key)) {
                this.setTraveling_utils_hr(Double.parseDouble(value));
            } else if (TRAVELING_PT.equals(key)) {
                this.setTravelingPt_utils_hr(Double.parseDouble(value));
            } else if (TRAVELING_WALK.equals(key)) {
                this.setTravelingWalk_utils_hr(Double.parseDouble(value));
            } else if (TRAVELING_OTHER.equals(key)) {
                this.setTravelingOther_utils_hr(Double.parseDouble(value));
            } else if (TRAVELING_BIKE.equals(key)) {
                this.setTravelingBike_utils_hr(Double.parseDouble(value));
            } else if (MARGINAL_UTL_OF_DISTANCE_CAR.equals(key)) {
                this.setMarginalUtlOfDistanceCar(Double.parseDouble(value));
            } else if (MARGINAL_UTL_OF_DISTANCE_PT.equals(key)) {
                this.setMarginalUtlOfDistancePt(Double.parseDouble(value));
            } else if (MARGINAL_UTL_OF_DISTANCE_WALK.equals(key)) {
                this.setMarginalUtlOfDistanceWalk(Double.parseDouble(value));
            } else if (MARGINAL_UTL_OF_DISTANCE_OTHER.equals(key)) {
                this.setMarginalUtlOfDistanceOther(Double.parseDouble(value));
            } else if (CONSTANT_CAR.equals(key)) {
                this.setConstantCar(Double.parseDouble(value));
            } else if (CONSTANT_WALK.equals(key)) {
                this.setConstantWalk(Double.parseDouble(value));
            } else if (CONSTANT_OTHER.equals(key)) {
                this.setConstantOther(Double.parseDouble(value));
            } else if (CONSTANT_PT.equals(key)) {
                this.setConstantPt(Double.parseDouble(value));
            } else if (CONSTANT_BIKE.equals(key)) {
                this.setConstantBike(Double.parseDouble(value));
            } else if (WAITING_PT.equals(key)) {
                this.setMarginalUtlOfWaitingPt_utils_hr(Double.parseDouble(value));
            } else {
                this.delegate.addParam(key, value);
            }
        }
    }

    public ModeParams getOrCreateModeParams(String modeName) {
        ModeParams modeParams = this.getModes().get(modeName);
        if (modeParams == null) {
            modeParams = new ModeParams(modeName);
            this.addParameterSet(modeParams);
        }
        return modeParams;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> params = this.delegate.getParams();
        if (this.waitingPt != null) {
            params.put(WAITING_PT, this.waitingPt.toString());
        }
        return params;
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(FRACTION_OF_ITERATIONS_TO_START_SCORE_MSA, "fraction of iterations at which MSA score averaging is started. The matsim theory department suggests to use this together with switching off choice set innovation (where a similar switch exists), but it has not been tested yet.");
        map.put(USING_OLD_SCORING_BELOW_ZERO_UTILITY_DURATION, "There used to be a plateau between duration=0 and duration=zeroUtilityDuration. This caused durations to evolve to zero once they were below zeroUtilityDuration, causing problems.  Only use this switch if you need to be backwards compatible with some old results.  (changed nov'13)");
        map.put(PERFORMING, "[utils/hr] marginal utility of doing an activity.  normally positive.  also the opportunity cost of time if agent is doing nothing.  MATSim separates the resource value of time from the direct (dis)utility of travel time, see, e.g., Boerjesson and Eliasson, TR-A 59 (2014) 144-158.");
        map.put(LATE_ARRIVAL, "[utils/hr] utility for arriving late (i.e. after the latest start time).  normally negative");
        map.put(EARLY_DEPARTURE, "[utils/hr] utility for departing early (i.e. before the earliest end time).  Normally negative.  Probably implemented correctly, but not tested.");
        map.put(WAITING, "[utils/hr] additional marginal utility for waiting. normally negative. this comes on top of the opportunity cost of time.  Probably implemented correctly, but not tested.");
        map.put(WAITING_PT, "[utils/hr] additional marginal utility for waiting for a pt vehicle. normally negative. this comes on top of the opportunity cost of time. Default: if not set explicitly, it is equal to traveling_pt!!!");
        map.put(BRAIN_EXP_BETA, "logit model scale parameter. default: 1.  Has name and default value for historical reasons (see Bryan Raney's phd thesis).");
        map.put(LEARNING_RATE, "new_score = (1-learningRate)*old_score + learningRate * score_from_mobsim.  learning rates close to zero emulate score averaging, but slow down initial convergence");
        map.put(UTL_OF_LINE_SWITCH, "[utils] utility of switching a line (= transfer penalty).  Normally negative");
        map.put(MARGINAL_UTL_OF_MONEY, "[utils/unit_of_money] conversion of money (e.g. toll, distance cost) into utils. Normall positive (i.e. toll/cost/fare are processed as negative amounts of money).");
        map.put(WRITE_EXPERIENCED_PLANS, "write a plans file in each iteration directory which contains what each agent actually did, and the score it received.");
        return map;
    }

    private ActivityParams getActivityTypeByNumber(String number, boolean createIfMissing) {
        ActivityParams actType = this.activityTypesByNumber.get(number);
        if (actType == null && createIfMissing) {
            actType = new ActivityParams(number);
            this.activityTypesByNumber.put(number, actType);
            this.addParameterSet(actType);
        }
        return actType;
    }

    public Collection<String> getActivityTypes() {
        return this.getActivityParamsPerType().keySet();
    }

    public Collection<ActivityParams> getActivityParams() {
        Collection<? extends ConfigGroup> collection = this.getParameterSets("activityParams");
        for (ActivityParams activityParams : collection) {
            if (!this.isLocked()) continue;
            activityParams.setLocked();
        }
        return collection;
    }

    public Map<String, ActivityParams> getActivityParamsPerType() {
        LinkedHashMap<String, ActivityParams> map = new LinkedHashMap<String, ActivityParams>();
        for (ActivityParams pars : this.getActivityParams()) {
            map.put(pars.getActivityType(), pars);
        }
        return map;
    }

    public Map<String, ModeParams> getModes() {
        Collection<? extends ConfigGroup> modes = this.getParameterSets("modeParams");
        LinkedHashMap<String, ModeParams> map = new LinkedHashMap<String, ModeParams>();
        for (ModeParams modeParams : modes) {
            if (this.isLocked()) {
                modeParams.setLocked();
            }
            map.put(modeParams.getMode(), modeParams);
        }
        return map;
    }

    @Override
    public void checkConsistency(Config config) {
        super.checkConsistency(config);
        boolean hasOpeningAndClosingTime = false;
        boolean hasOpeningTimeAndLatePenalty = false;
        for (ActivityParams actType : this.getActivityParams()) {
            if (!actType.isScoringThisActivityAtAll()) continue;
            if (actType.getOpeningTime() != Double.NEGATIVE_INFINITY && actType.getClosingTime() != Double.NEGATIVE_INFINITY) {
                hasOpeningAndClosingTime = true;
            }
            if (actType.getOpeningTime() != Double.NEGATIVE_INFINITY && this.getLateArrival_utils_hr() < -0.001) {
                hasOpeningTimeAndLatePenalty = true;
            }
            if (actType.getOpeningTime() != 0.0 || !(actType.getClosingTime() > 86399.0)) continue;
            log.error("it looks like you have an activity type with opening time set to 0:00 and closing time set to 24:00. This is most probably not the same as not setting them at all.  In particular, activities which extend past midnight may not accumulate scores.");
        }
        if (!hasOpeningAndClosingTime && !hasOpeningTimeAndLatePenalty) {
            log.info("NO OPENING OR CLOSING TIMES DEFINED!\n\n\nThere is no activity type that has an opening *and* closing time (or opening time and late penalty) defined.\nThis usually means that the activity chains can be shifted by an arbitrary\nnumber of hours without having an effect on the score of the plans, and thus\nresulting in wrong results / traffic patterns.\nIf you are using MATSim without time adaptation, you can ignore this warning.\n\n\n");
        }
        if (this.getMarginalUtlOfWaiting_utils_hr() != 0.0) {
            log.warn("marginal utl of wait set to: " + this.getMarginalUtlOfWaiting_utils_hr() + ". Setting this different from zero is " + "discouraged. The parameter was also abused for pt routing; if you did that, consider setting the new " + "parameter waitingPt instead.");
        }
    }

    public double getMarginalUtlOfWaitingPt_utils_hr() {
        return this.waitingPt == null ? this.getModes().get("pt").getMarginalUtilityOfTraveling() : this.waitingPt.doubleValue();
    }

    public double getTraveling_utils_hr() {
        return this.getModes().get("car").getMarginalUtilityOfTraveling();
    }

    public void setTraveling_utils_hr(double traveling) {
        this.getModes().get("car").setMarginalUtilityOfTraveling(traveling);
    }

    public double getTravelingPt_utils_hr() {
        return this.getModes().get("pt").getMarginalUtilityOfTraveling();
    }

    public void setTravelingPt_utils_hr(double travelingPt) {
        this.getModes().get("pt").setMarginalUtilityOfTraveling(travelingPt);
    }

    public double getTravelingBike_utils_hr() {
        return this.getModes().get("bike").getMarginalUtilityOfTraveling();
    }

    public void setTravelingBike_utils_hr(double travelingBike) {
        this.getModes().get("bike").setMarginalUtilityOfTraveling(travelingBike);
    }

    public double getTravelingWalk_utils_hr() {
        return this.getModes().get("walk").getMarginalUtilityOfTraveling();
    }

    public void setTravelingWalk_utils_hr(double travelingWalk) {
        this.getModes().get("walk").setMarginalUtilityOfTraveling(travelingWalk);
    }

    public double getMarginalUtlOfDistanceWalk() {
        return this.getModes().get("walk").getMarginalUtilityOfDistance();
    }

    public void setMarginalUtlOfDistanceWalk(double marginalUtlOfDistanceWalk) {
        this.getModes().get("walk").setMarginalUtilityOfDistance(marginalUtlOfDistanceWalk);
    }

    private void setMarginalUtlOfDistancePt(double marginalUtlOfDistancePt) {
        this.getModes().get("pt").setMarginalUtilityOfDistance(marginalUtlOfDistancePt);
    }

    private void setMarginalUtlOfDistanceCar(double marginalUtlOfDistanceCar) {
        this.getModes().get("car").setMarginalUtilityOfDistance(marginalUtlOfDistanceCar);
    }

    public void setMarginalUtlOfWaitingPt_utils_hr(double val) {
        this.waitingPt = val;
    }

    public ActivityParams getActivityParams(String actType) {
        return this.getActivityParamsPerType().get(actType);
    }

    @Override
    public void addParameterSet(ConfigGroup set) {
        switch (set.getName()) {
            case "activityParams": {
                this.addActivityParams((ActivityParams)set);
                break;
            }
            case "modeParams": {
                this.addModeParams((ModeParams)set);
                break;
            }
            default: {
                throw new IllegalArgumentException(set.getName());
            }
        }
    }

    public void addModeParams(ModeParams params) {
        ModeParams previous = this.getModes().get(params.getMode());
        if (previous != null) {
            log.info("mode parameters for mode " + previous.getMode() + " were just overwritten.");
            boolean removed = this.removeParameterSet(previous);
            if (!removed) {
                throw new RuntimeException("problem replacing mode params ");
            }
        }
        super.addParameterSet(params);
    }

    public void addActivityParams(ActivityParams params) {
        ActivityParams previous = this.getActivityParams(params.getActivityType());
        if (previous != null) {
            if (previous.getActivityType().equals("pt interaction")) {
                log.error("ERROR: Activity parameters for activity type " + previous.getActivityType() + " were just overwritten. This happens most " + "likely because you defined them in the config file and the Controler overwrites them.  Or the other way " + "round.  pt interaction has problems, but doing what you are doing here will just cause " + "other (less visible) problem. Please take the effort to discuss with the core team " + "what needs to be done.  kai, nov'12");
            } else {
                log.info("activity parameters for activity type " + previous.getActivityType() + " were just overwritten.");
            }
            boolean removed = this.removeParameterSet(previous);
            if (!removed) {
                throw new RuntimeException("problem replacing activity params ");
            }
        }
        super.addParameterSet(params);
    }

    @Override
    public ConfigGroup createParameterSet(String type) {
        switch (type) {
            case "activityParams": {
                return new ActivityParams();
            }
            case "modeParams": {
                return new ModeParams();
            }
        }
        throw new IllegalArgumentException(type);
    }

    @Override
    protected void checkParameterSet(ConfigGroup module) {
        switch (module.getName()) {
            case "activityParams": {
                if (!(module instanceof ActivityParams)) {
                    throw new RuntimeException("wrong class for " + module);
                }
                String t = ((ActivityParams)module).getActivityType();
                if (this.getActivityParams(t) == null) break;
                throw new IllegalStateException("already a parameter set for activity type " + t);
            }
            case "modeParams": {
                if (!(module instanceof ModeParams)) {
                    throw new RuntimeException("wrong class for " + module);
                }
                String m3 = ((ModeParams)module).getMode();
                if (this.getModes().get(m3) == null) break;
                throw new IllegalStateException("already a parameter set for mode " + m3);
            }
            default: {
                throw new IllegalArgumentException(module.getName());
            }
        }
    }

    @Deprecated
    public double getMonetaryDistanceRateCar() {
        return this.getModes().get("car").getMonetaryDistanceRate();
    }

    @Deprecated
    public void setMonetaryDistanceRateCar(double monetaryDistanceRateCar) {
        this.getModes().get("car").setMonetaryDistanceRate(monetaryDistanceRateCar);
    }

    @Deprecated
    public double getMonetaryDistanceRatePt() {
        return this.getModes().get("pt").getMonetaryDistanceRate();
    }

    @Deprecated
    public void setMonetaryDistanceRatePt(double monetaryDistanceRatePt) {
        this.getModes().get("pt").setMonetaryDistanceRate(monetaryDistanceRatePt);
    }

    @Deprecated
    public double getConstantCar() {
        return this.getModes().get("car").getConstant();
    }

    @Deprecated
    public void setConstantCar(double constantCar) {
        this.getModes().get("car").setConstant(constantCar);
    }

    @Deprecated
    public double getConstantWalk() {
        return this.getModes().get("walk").getConstant();
    }

    @Deprecated
    public void setConstantWalk(double constantWalk) {
        this.getModes().get("walk").setConstant(constantWalk);
    }

    @Deprecated
    public double getConstantPt() {
        return this.getModes().get("pt").getConstant();
    }

    @Deprecated
    public void setConstantPt(double constantPt) {
        this.getModes().get("pt").setConstant(constantPt);
    }

    @Deprecated
    public double getConstantBike() {
        return this.getModes().get("bike").getConstant();
    }

    @Deprecated
    public void setConstantBike(double constantBike) {
        this.getModes().get("bike").setConstant(constantBike);
    }

    @Deprecated
    public double getTravelingOther_utils_hr() {
        return this.getModes().get("other").getMarginalUtilityOfTraveling();
    }

    @Deprecated
    public double getConstantOther() {
        return this.getModes().get("other").getConstant();
    }

    @Deprecated
    public double getMarginalUtlOfDistanceOther() {
        return this.getModes().get("other").getMarginalUtilityOfDistance();
    }

    @Deprecated
    public void setMarginalUtlOfDistanceOther(double marginalUtlOfDistanceOther) {
        this.getModes().get("other").setMarginalUtilityOfDistance(marginalUtlOfDistanceOther);
    }

    @Deprecated
    public void setConstantOther(double constantOther) {
        this.getModes().get("other").setConstant(constantOther);
    }

    @Deprecated
    public void setTravelingOther_utils_hr(double travelingOtherUtilsHr) {
        this.getModes().get("other").setMarginalUtilityOfTraveling(travelingOtherUtilsHr);
    }

    public boolean isMemorizingExperiencedPlans() {
        return this.memorizingExperiencedPlans;
    }

    public void setMemorizingExperiencedPlans(boolean memorizingExperiencedPlans) {
        this.memorizingExperiencedPlans = memorizingExperiencedPlans;
    }

    public double getLearningRate() {
        return this.delegate.getLearningRate();
    }

    public void setLearningRate(double learningRate) {
        this.delegate.setLearningRate(learningRate);
    }

    public double getBrainExpBeta() {
        return this.delegate.getBrainExpBeta();
    }

    public void setBrainExpBeta(double brainExpBeta) {
        this.delegate.setBrainExpBeta(brainExpBeta);
    }

    public double getPathSizeLogitBeta() {
        return this.delegate.getPathSizeLogitBeta();
    }

    public void setPathSizeLogitBeta(double beta) {
        this.delegate.setPathSizeLogitBeta(beta);
    }

    public double getLateArrival_utils_hr() {
        return this.delegate.getLateArrival_utils_hr();
    }

    public void setLateArrival_utils_hr(double lateArrival) {
        this.delegate.setLateArrival_utils_hr(lateArrival);
    }

    public double getEarlyDeparture_utils_hr() {
        return this.delegate.getEarlyDeparture_utils_hr();
    }

    public void setEarlyDeparture_utils_hr(double earlyDeparture) {
        this.delegate.setEarlyDeparture_utils_hr(earlyDeparture);
    }

    public double getPerforming_utils_hr() {
        return this.delegate.getPerforming_utils_hr();
    }

    public void setPerforming_utils_hr(double performing) {
        this.delegate.setPerforming_utils_hr(performing);
    }

    public double getMarginalUtilityOfMoney() {
        return this.delegate.getMarginalUtilityOfMoney();
    }

    public void setMarginalUtilityOfMoney(double marginalUtilityOfMoney) {
        this.delegate.setMarginalUtilityOfMoney(marginalUtilityOfMoney);
    }

    public double getUtilityOfLineSwitch() {
        return this.delegate.getUtilityOfLineSwitch();
    }

    public void setUtilityOfLineSwitch(double utilityOfLineSwitch) {
        this.delegate.setUtilityOfLineSwitch(utilityOfLineSwitch);
    }

    public boolean isUsingOldScoringBelowZeroUtilityDuration() {
        return this.delegate.isUsingOldScoringBelowZeroUtilityDuration();
    }

    public void setUsingOldScoringBelowZeroUtilityDuration(boolean usingOldScoringBelowZeroUtilityDuration) {
        this.delegate.setUsingOldScoringBelowZeroUtilityDuration(usingOldScoringBelowZeroUtilityDuration);
    }

    public boolean isWriteExperiencedPlans() {
        return this.delegate.isWriteExperiencedPlans();
    }

    public void setWriteExperiencedPlans(boolean writeExperiencedPlans) {
        this.delegate.setWriteExperiencedPlans(writeExperiencedPlans);
    }

    public double getMarginalUtlOfWaiting_utils_hr() {
        return this.delegate.getMarginalUtlOfWaiting_utils_hr();
    }

    public void setMarginalUtlOfWaiting_utils_hr(double waiting) {
        this.delegate.setMarginalUtlOfWaiting_utils_hr(waiting);
    }

    public void setFractionOfIterationsToStartScoreMSA(Double val) {
        this.delegate.setFractionOfIterationsToStartScoreMSA(val);
    }

    public Double getFractionOfIterationsToStartScoreMSA() {
        return this.delegate.getFractionOfIterationsToStartScoreMSA();
    }

    @Override
    public final void setLocked() {
        super.setLocked();
        this.delegate.setLocked();
    }

    private static class ReflectiveDelegate
    extends ReflectiveConfigGroup {
        private double learningRate = 1.0;
        private double brainExpBeta = 1.0;
        private double pathSizeLogitBeta = 1.0;
        private double lateArrival = -18.0;
        private double earlyDeparture = -0.0;
        private double performing = 6.0;
        private double waiting = -0.0;
        private double marginalUtilityOfMoney = 1.0;
        private double utilityOfLineSwitch = -1.0;
        private boolean usingOldScoringBelowZeroUtilityDuration = false;
        private boolean writeExperiencedPlans = false;
        private Double fractionOfIterationsToStartScoreMSA = null;
        private static int setWaitingCnt = 0;

        private ReflectiveDelegate() {
            super(OldToNewPlanCalcScoreConfigGroup.GROUP_NAME);
        }

        @ReflectiveConfigGroup.StringGetter(value="fractionOfIterationsToStartScoreMSA")
        public Double getFractionOfIterationsToStartScoreMSA() {
            return this.fractionOfIterationsToStartScoreMSA;
        }

        @ReflectiveConfigGroup.StringSetter(value="fractionOfIterationsToStartScoreMSA")
        public void setFractionOfIterationsToStartScoreMSA(Double fractionOfIterationsToStartScoreMSA) {
            this.testForLocked();
            this.fractionOfIterationsToStartScoreMSA = fractionOfIterationsToStartScoreMSA;
        }

        @ReflectiveConfigGroup.StringGetter(value="learningRate")
        public double getLearningRate() {
            return this.learningRate;
        }

        @ReflectiveConfigGroup.StringSetter(value="learningRate")
        public void setLearningRate(double learningRate) {
            this.testForLocked();
            this.learningRate = learningRate;
        }

        @ReflectiveConfigGroup.StringGetter(value="BrainExpBeta")
        public double getBrainExpBeta() {
            return this.brainExpBeta;
        }

        @ReflectiveConfigGroup.StringSetter(value="BrainExpBeta")
        public void setBrainExpBeta(double brainExpBeta) {
            this.testForLocked();
            this.brainExpBeta = brainExpBeta;
        }

        @ReflectiveConfigGroup.StringGetter(value="PathSizeLogitBeta")
        public double getPathSizeLogitBeta() {
            return this.pathSizeLogitBeta;
        }

        @ReflectiveConfigGroup.StringSetter(value="PathSizeLogitBeta")
        public void setPathSizeLogitBeta(double beta) {
            this.testForLocked();
            if (beta != 0.0) {
                log.warn("Setting pathSizeLogitBeta different from zero is experimental.  KN, Sep'08");
            }
            this.pathSizeLogitBeta = beta;
        }

        @ReflectiveConfigGroup.StringGetter(value="lateArrival")
        public double getLateArrival_utils_hr() {
            return this.lateArrival;
        }

        @ReflectiveConfigGroup.StringSetter(value="lateArrival")
        public void setLateArrival_utils_hr(double lateArrival) {
            this.testForLocked();
            this.lateArrival = lateArrival;
        }

        @ReflectiveConfigGroup.StringGetter(value="earlyDeparture")
        public double getEarlyDeparture_utils_hr() {
            return this.earlyDeparture;
        }

        @ReflectiveConfigGroup.StringSetter(value="earlyDeparture")
        public void setEarlyDeparture_utils_hr(double earlyDeparture) {
            this.testForLocked();
            this.earlyDeparture = earlyDeparture;
        }

        @ReflectiveConfigGroup.StringGetter(value="performing")
        public double getPerforming_utils_hr() {
            return this.performing;
        }

        @ReflectiveConfigGroup.StringSetter(value="performing")
        public void setPerforming_utils_hr(double performing) {
            this.performing = performing;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfMoney")
        public double getMarginalUtilityOfMoney() {
            return this.marginalUtilityOfMoney;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfMoney")
        public void setMarginalUtilityOfMoney(double marginalUtilityOfMoney) {
            this.testForLocked();
            this.marginalUtilityOfMoney = marginalUtilityOfMoney;
        }

        @ReflectiveConfigGroup.StringGetter(value="utilityOfLineSwitch")
        public double getUtilityOfLineSwitch() {
            return this.utilityOfLineSwitch;
        }

        @ReflectiveConfigGroup.StringSetter(value="utilityOfLineSwitch")
        public void setUtilityOfLineSwitch(double utilityOfLineSwitch) {
            this.testForLocked();
            this.utilityOfLineSwitch = utilityOfLineSwitch;
        }

        @ReflectiveConfigGroup.StringGetter(value="usingOldScoringBelowZeroUtilityDuration")
        public boolean isUsingOldScoringBelowZeroUtilityDuration() {
            return this.usingOldScoringBelowZeroUtilityDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="usingOldScoringBelowZeroUtilityDuration")
        public void setUsingOldScoringBelowZeroUtilityDuration(boolean usingOldScoringBelowZeroUtilityDuration) {
            this.testForLocked();
            this.usingOldScoringBelowZeroUtilityDuration = usingOldScoringBelowZeroUtilityDuration;
        }

        @ReflectiveConfigGroup.StringGetter(value="writeExperiencedPlans")
        public boolean isWriteExperiencedPlans() {
            return this.writeExperiencedPlans;
        }

        @ReflectiveConfigGroup.StringSetter(value="writeExperiencedPlans")
        public void setWriteExperiencedPlans(boolean writeExperiencedPlans) {
            this.testForLocked();
            this.writeExperiencedPlans = writeExperiencedPlans;
        }

        @ReflectiveConfigGroup.StringGetter(value="waiting")
        public double getMarginalUtlOfWaiting_utils_hr() {
            return this.waiting;
        }

        @ReflectiveConfigGroup.StringSetter(value="waiting")
        public void setMarginalUtlOfWaiting_utils_hr(double waiting) {
            this.testForLocked();
            if (waiting != 0.0 && setWaitingCnt < 1) {
                ++setWaitingCnt;
                log.warn("Setting betaWaiting different from zero is discouraged.  It is probably implemented correctly, but there is as of now no indication that it makes the results more realistic. This message given only once.");
            }
            this.waiting = waiting;
        }
    }

    public static class ModeParams
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        static final String SET_TYPE = "modeParams";
        private String mode = null;
        private double traveling = -6.0;
        private double distance = 0.0;
        private double monetaryDistanceRate = 0.0;
        private double constant = 0.0;

        public ModeParams(String mode) {
            super(SET_TYPE);
            this.setMode(mode);
        }

        ModeParams() {
            super(SET_TYPE);
        }

        @Override
        public Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            map.put("marginalUtilityOfTraveling_util_hr", "[utils/hr] additional marginal utility of traveling.  normally negative.  this comes on top of the opportunity cost of time");
            map.put("marginalUtilityOfDistance_util_m", "[utils/m] utility of walking per m, normally negative.  this is on top of the time (dis)utility.");
            map.put(OldToNewPlanCalcScoreConfigGroup.MONETARY_DISTANCE_COST_RATE, "[unit_of_money/m] conversion of distance into money. Probably needs to be negative to work.");
            map.put("constant", "[utils] alternative-specific constant.  no guarantee that this is used anywhere. default=0 to be backwards compatible for the time being");
            return map;
        }

        @ReflectiveConfigGroup.StringSetter(value="mode")
        public void setMode(String mode) {
            this.testForLocked();
            this.mode = mode;
        }

        @ReflectiveConfigGroup.StringGetter(value="mode")
        public String getMode() {
            return this.mode;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfTraveling_util_hr")
        public void setMarginalUtilityOfTraveling(double traveling) {
            this.testForLocked();
            this.traveling = traveling;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfTraveling_util_hr")
        public double getMarginalUtilityOfTraveling() {
            return this.traveling;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfDistance_util_m")
        public double getMarginalUtilityOfDistance() {
            return this.distance;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfDistance_util_m")
        public void setMarginalUtilityOfDistance(double distance) {
            this.testForLocked();
            this.distance = distance;
        }

        @ReflectiveConfigGroup.StringGetter(value="constant")
        public double getConstant() {
            return this.constant;
        }

        @ReflectiveConfigGroup.StringSetter(value="constant")
        public void setConstant(double constant) {
            this.testForLocked();
            this.constant = constant;
        }

        @ReflectiveConfigGroup.StringGetter(value="monetaryDistanceRate")
        public double getMonetaryDistanceRate() {
            return this.monetaryDistanceRate;
        }

        @ReflectiveConfigGroup.StringSetter(value="monetaryDistanceRate")
        public void setMonetaryDistanceRate(double monetaryDistanceRate) {
            this.testForLocked();
            this.monetaryDistanceRate = monetaryDistanceRate;
        }
    }

    public static class ActivityParams
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        private static final String TYPICAL_DURATION_SCORE_COMPUTATION = "typicalDurationScoreComputation";
        static final String SET_TYPE = "activityParams";
        private String type;
        private double priority = 1.0;
        private double typicalDuration = Time.getUndefinedTime();
        private double minimalDuration = Time.getUndefinedTime();
        private double openingTime = Time.getUndefinedTime();
        private double latestStartTime = Time.getUndefinedTime();
        private double earliestEndTime = Time.getUndefinedTime();
        private double closingTime = Time.getUndefinedTime();
        private boolean scoringThisActivityAtAll = true;
        private TypicalDurationScoreComputation typicalDurationScoreComputation = TypicalDurationScoreComputation.uniform;
        private static int minDurCnt = 0;

        public ActivityParams() {
            super(SET_TYPE);
        }

        public ActivityParams(String type) {
            super(SET_TYPE);
            this.type = type;
        }

        @Override
        public Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            map.put(TYPICAL_DURATION_SCORE_COMPUTATION, "method to compute score at typical duration.  Use " + (Object)((Object)TypicalDurationScoreComputation.uniform) + " for backwards compatibility (all activities same score; higher proba to drop long acts).");
            return map;
        }

        @ReflectiveConfigGroup.StringGetter(value="typicalDurationScoreComputation")
        public TypicalDurationScoreComputation getTypicalDurationScoreComputation() {
            return this.typicalDurationScoreComputation;
        }

        @ReflectiveConfigGroup.StringSetter(value="typicalDurationScoreComputation")
        public void setTypicalDurationScoreComputation(TypicalDurationScoreComputation str) {
            this.testForLocked();
            this.typicalDurationScoreComputation = str;
        }

        @ReflectiveConfigGroup.StringGetter(value="activityType")
        public String getActivityType() {
            return this.type;
        }

        @ReflectiveConfigGroup.StringSetter(value="activityType")
        public void setActivityType(String type) {
            this.testForLocked();
            this.type = type;
        }

        @ReflectiveConfigGroup.StringGetter(value="priority")
        public double getPriority() {
            return this.priority;
        }

        @ReflectiveConfigGroup.StringSetter(value="priority")
        public void setPriority(double priority) {
            this.testForLocked();
            this.priority = priority;
        }

        @ReflectiveConfigGroup.StringGetter(value="typicalDuration")
        private String getTypicalDurationString() {
            return Time.writeTime(this.getTypicalDuration());
        }

        public double getTypicalDuration() {
            return this.typicalDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="typicalDuration")
        private void setTypicalDuration(String typicalDuration) {
            this.testForLocked();
            this.setTypicalDuration(Time.parseTime(typicalDuration));
        }

        public void setTypicalDuration(double typicalDuration) {
            this.testForLocked();
            this.typicalDuration = typicalDuration;
        }

        @ReflectiveConfigGroup.StringGetter(value="minimalDuration")
        private String getMinimalDurationString() {
            return Time.writeTime(this.getMinimalDuration());
        }

        public double getMinimalDuration() {
            return this.minimalDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="minimalDuration")
        private void setMinimalDuration(String minimalDuration) {
            this.testForLocked();
            this.setMinimalDuration(Time.parseTime(minimalDuration));
        }

        public void setMinimalDuration(double minimalDuration) {
            this.testForLocked();
            if (!Time.isUndefinedTime(minimalDuration) && minDurCnt < 1) {
                ++minDurCnt;
                log.warn("Setting minimalDuration different from zero is discouraged.  It is probably implemented correctly, but there is as of now no indication that it makes the results more realistic.  KN, Sep'08 This message given only once.");
            }
            this.minimalDuration = minimalDuration;
        }

        @ReflectiveConfigGroup.StringGetter(value="openingTime")
        private String getOpeningTimeString() {
            return Time.writeTime(this.getOpeningTime());
        }

        public double getOpeningTime() {
            return this.openingTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="openingTime")
        private void setOpeningTime(String openingTime) {
            this.testForLocked();
            this.setOpeningTime(Time.parseTime(openingTime));
        }

        public void setOpeningTime(double openingTime) {
            this.testForLocked();
            this.openingTime = openingTime;
        }

        @ReflectiveConfigGroup.StringGetter(value="latestStartTime")
        private String getLatestStartTimeString() {
            return Time.writeTime(this.getLatestStartTime());
        }

        public double getLatestStartTime() {
            return this.latestStartTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="latestStartTime")
        private void setLatestStartTime(String latestStartTime) {
            this.testForLocked();
            this.setLatestStartTime(Time.parseTime(latestStartTime));
        }

        public void setLatestStartTime(double latestStartTime) {
            this.testForLocked();
            this.latestStartTime = latestStartTime;
        }

        @ReflectiveConfigGroup.StringGetter(value="earliestEndTime")
        private String getEarliestEndTimeString() {
            return Time.writeTime(this.getEarliestEndTime());
        }

        public double getEarliestEndTime() {
            return this.earliestEndTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="earliestEndTime")
        private void setEarliestEndTime(String earliestEndTime) {
            this.testForLocked();
            this.setEarliestEndTime(Time.parseTime(earliestEndTime));
        }

        public void setEarliestEndTime(double earliestEndTime) {
            this.testForLocked();
            this.earliestEndTime = earliestEndTime;
        }

        @ReflectiveConfigGroup.StringGetter(value="closingTime")
        private String getClosingTimeString() {
            return Time.writeTime(this.getClosingTime());
        }

        public double getClosingTime() {
            return this.closingTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="closingTime")
        private void setClosingTime(String closingTime) {
            this.testForLocked();
            this.setClosingTime(Time.parseTime(closingTime));
        }

        public void setClosingTime(double closingTime) {
            this.testForLocked();
            this.closingTime = closingTime;
        }

        @ReflectiveConfigGroup.StringGetter(value="scoringThisActivityAtAll")
        public boolean isScoringThisActivityAtAll() {
            return this.scoringThisActivityAtAll;
        }

        @ReflectiveConfigGroup.StringSetter(value="scoringThisActivityAtAll")
        public void setScoringThisActivityAtAll(boolean scoringThisActivityAtAll) {
            this.testForLocked();
            this.scoringThisActivityAtAll = scoringThisActivityAtAll;
        }
    }

    public static enum TypicalDurationScoreComputation {
        uniform,
        relative;

    }
}

