/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run;

import java.util.Iterator;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.population.io.StreamingPopulationWriter;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.misc.ArgumentParser;

public class XY2Links {
    private Config config;
    private String configfile = null;
    private String plansfile = null;

    private void parseArguments(String[] args) {
        Iterator<String> argIter;
        String arg;
        if (args.length == 0) {
            System.out.println("Too few arguments.");
            this.printUsage();
            System.exit(1);
        }
        if ((arg = (argIter = new ArgumentParser(args).iterator()).next()).equals("-h") || arg.equals("--help")) {
            this.printUsage();
            System.exit(0);
        } else {
            this.configfile = arg;
            this.plansfile = argIter.next();
            if (argIter.hasNext()) {
                System.out.println("Too many arguments.");
                this.printUsage();
                System.exit(1);
            }
        }
    }

    private void printUsage() {
        System.out.println();
        System.out.println("XY2Links");
        System.out.println("Reads a plans-file and assignes each activity in each plan of each person");
        System.out.println("a link based on the coordinates given in the activity. The modified plans/");
        System.out.println("persons are then written out to file again.");
        System.out.println();
        System.out.println("usage: XY2Links [OPTIONS] configfile plansfile");
        System.out.println("       The following parameters must be given in the config-file:");
        System.out.println("       - network.inputNetworkFile");
        System.out.println("       - plans.inputPlansFile");
        System.out.println();
        System.out.println("Options:");
        System.out.println("-h, --help:     Displays this message.");
        System.out.println();
        System.out.println("----------------");
        System.out.println("2008, matsim.org");
        System.out.println();
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.config = ConfigUtils.loadConfig(this.configfile, new ConfigGroup[0]);
        MatsimRandom.reset(this.config.global().getRandomSeed());
        MutableScenario scenario = ScenarioUtils.createMutableScenario(this.config);
        new MatsimNetworkReader(scenario.getNetwork()).readFile(this.config.network().getInputFile());
        this.config = scenario.getConfig();
        StreamingPopulationReader reader = new StreamingPopulationReader(scenario);
        StreamingPopulationWriter plansWriter = new StreamingPopulationWriter();
        plansWriter.startStreaming(this.plansfile);
        reader.addAlgorithm(new org.matsim.core.population.algorithms.XY2Links(scenario));
        reader.addAlgorithm(plansWriter);
        reader.readFile(this.config.plans().getInputFile());
        PopulationUtils.printPlansCount(reader);
        plansWriter.closeStreaming();
        System.out.println("done.");
    }

    public static void main(String[] args) {
        new XY2Links().run(args);
    }
}

