/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

class AsyncFileInputProgressDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(AsyncFileInputProgressDialog.class);
    private static final long serialVersionUID = 1L;

    public AsyncFileInputProgressDialog(FileInputStream fis) {
        this(fis, "Operation in Progress\u2026");
    }

    public AsyncFileInputProgressDialog(final FileInputStream fis, String title) {
        this.setTitle(title);
        final JProgressBar progressbar = new JProgressBar(0, 1000);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(progressbar, -1, 300, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(progressbar).addContainerGap()));
        this.getContentPane().setLayout(groupLayout);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                FileChannel ch = fis.getChannel();
                while (ch.isOpen()) {
                    try {
                        long size = ch.size();
                        long pos = ch.position();
                        final int progress = (int)((double)pos / (double)size * 1000.0);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressbar.setValue(progress);
                            }
                        });
                        Thread.sleep(250L);
                    }
                    catch (IOException | InterruptedException e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        }, "ProgressObserver");
        t.setDaemon(true);
        t.start();
        this.setModal(false);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h2 = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h2) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }
}

