/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.run.gui.SaveFileSaver;

public class ConfigEditor
extends JFrame {
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    private JButton btnSave;
    private File configFile;
    private JTextPane xmlPane;
    private ConfigChangeListener configChangeListener;

    public ConfigEditor(File configFile, ConfigChangeListener configChangeListener) {
        this.setTitle("Config Editor");
        this.configChangeListener = configChangeListener;
        this.configFile = configFile;
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(e -> this.save());
        JButton btnSaveAs = new JButton("Save as\u2026");
        btnSaveAs.addActionListener(e -> this.saveAs());
        JScrollPane scrollPane = new JScrollPane();
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnSaveAs).addContainerGap(471, Short.MAX_VALUE)).addComponent(scrollPane, GroupLayout.Alignment.TRAILING, -1, 661, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSave).addComponent(btnSaveAs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane, -1, 456, Short.MAX_VALUE)));
        this.xmlPane = new JTextPane();
        this.xmlPane.setContentType("text/xml");
        this.xmlPane.setEditorKit(new XmlEditorKit());
        scrollPane.setViewportView(this.xmlPane);
        this.getContentPane().setLayout(groupLayout);
        UndoManager undoManager = this.addUndoFunctionality(this.xmlPane);
        this.addSaveFunctionality();
        this.addCloseFunctionality();
        this.setDefaultCloseOperation(1);
        this.pack();
        this.loadConfig();
        undoManager.discardAllEdits();
        this.btnSave.setEnabled(false);
        this.xmlPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConfigEditor.this.btnSave.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigEditor.this.btnSave.setEnabled(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConfigEditor.this.btnSave.setEnabled(true);
            }
        });
    }

    public void showEditor() {
        this.setVisible(true);
        this.xmlPane.requestFocus();
    }

    public void closeEditor() {
        this.setVisible(false);
    }

    public void saveAs() {
        SaveFileSaver chooser = new SaveFileSaver();
        chooser.setSelectedFile(this.configFile);
        int saveResult = chooser.showSaveDialog(null);
        if (saveResult == 0) {
            this.configFile = chooser.getSelectedFile();
            this.save();
        }
    }

    public void save() {
        String fullXml = this.xmlPane.getText();
        try (BufferedWriter writer = IOUtils.getBufferedWriter(this.configFile.getAbsolutePath());){
            writer.write(fullXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configChangeListener.configChanged(this.configFile);
        this.btnSave.setEnabled(false);
    }

    private UndoManager addUndoFunctionality(JTextPane textPane) {
        String UNDO_ACTION = "__UNDO__";
        String REDO_ACTION = "__REDO__";
        final UndoManager undoManager = new UndoManager();
        textPane.getDocument().addUndoableEditListener(pEvt -> undoManager.addEdit(pEvt.getEdit()));
        textPane.getActionMap().put(UNDO_ACTION, new AbstractAction(UNDO_ACTION){

            @Override
            public void actionPerformed(ActionEvent pEvt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException e) {
                    e.printStackTrace();
                }
            }
        });
        textPane.getActionMap().put(REDO_ACTION, new AbstractAction(REDO_ACTION){

            @Override
            public void actionPerformed(ActionEvent pEvt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException e) {
                    e.printStackTrace();
                }
            }
        });
        textPane.getInputMap().put(KeyStroke.getKeyStroke(90, IS_MAC ? 256 : 128), UNDO_ACTION);
        textPane.getInputMap().put(KeyStroke.getKeyStroke(89, IS_MAC ? 256 : 128), REDO_ACTION);
        return undoManager;
    }

    private void addSaveFunctionality() {
        String SAVE_ACTION = "__SAVE__";
        this.xmlPane.getActionMap().put(SAVE_ACTION, new AbstractAction(SAVE_ACTION){

            @Override
            public void actionPerformed(ActionEvent pEvt) {
                ConfigEditor.this.save();
            }
        });
        this.xmlPane.getInputMap().put(KeyStroke.getKeyStroke(83, IS_MAC ? 256 : 128), SAVE_ACTION);
    }

    private void addCloseFunctionality() {
        String CLOSE_ACTION = "__CLOSE__";
        this.xmlPane.getActionMap().put(CLOSE_ACTION, new AbstractAction(CLOSE_ACTION){

            @Override
            public void actionPerformed(ActionEvent pEvt) {
                ConfigEditor.this.setVisible(false);
            }
        });
        this.xmlPane.getInputMap().put(KeyStroke.getKeyStroke(87, IS_MAC ? 256 : 128), CLOSE_ACTION);
    }

    private void loadConfig() {
        StringBuilder buffer = new StringBuilder(1024);
        try (BufferedReader in = IOUtils.getBufferedReader(this.configFile.getAbsolutePath());){
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line);
                buffer.append(IOUtils.NATIVE_NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.xmlPane.setText(buffer.toString());
        this.xmlPane.setCaretPosition(0);
    }

    public static class XmlView
    extends PlainView {
        private static HashMap<Pattern, Color> patternColors;
        private static String TAG_PATTERN;
        private static String TAG_END_PATTERN;
        private static String TAG_ATTRIBUTE_PATTERN;
        private static String TAG_ATTRIBUTE_VALUE;
        private static String TAG_COMMENT;
        private static String TAG_CDATA_START;
        private static String TAG_CDATA_END;

        public XmlView(Element element) {
            super(element);
            this.getDocument().putProperty("tabSize", 4);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
            Document doc = this.getDocument();
            String text = doc.getText(p0, p1 - p0);
            Segment segment = this.getLineBuffer();
            TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Color> colorMap = new TreeMap<Integer, Color>();
            for (Map.Entry<Pattern, Color> entry : patternColors.entrySet()) {
                Matcher matcher = entry.getKey().matcher(text);
                while (matcher.find()) {
                    startMap.put(matcher.start(1), matcher.end());
                    colorMap.put(matcher.start(1), entry.getValue());
                }
            }
            int i = 0;
            for (Map.Entry entry : startMap.entrySet()) {
                int start = (Integer)entry.getKey();
                int end = (Integer)entry.getValue();
                if (i < start) {
                    graphics.setColor(Color.black);
                    doc.getText(p0 + i, start - i, segment);
                    x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
                }
                graphics.setColor((Color)colorMap.get(start));
                i = end;
                doc.getText(p0 + start, i - start, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
            }
            if (i < text.length()) {
                graphics.setColor(Color.black);
                doc.getText(p0 + i, text.length() - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            return x;
        }

        static {
            TAG_PATTERN = "(</?[a-z\\-]*)\\s?>?";
            TAG_END_PATTERN = "(/>)";
            TAG_ATTRIBUTE_PATTERN = "\\s(\\w*)\\=";
            TAG_ATTRIBUTE_VALUE = "[a-z-]*\\=(\"[^\"]*\")";
            TAG_COMMENT = "(<!--.*-->)";
            TAG_CDATA_START = "(\\<!\\[CDATA\\[).*";
            TAG_CDATA_END = ".*(]]>)";
            patternColors = new HashMap();
            patternColors.put(Pattern.compile(TAG_CDATA_START), new Color(128, 128, 128));
            patternColors.put(Pattern.compile(TAG_CDATA_END), new Color(128, 128, 128));
            patternColors.put(Pattern.compile(TAG_PATTERN), new Color(63, 127, 127));
            patternColors.put(Pattern.compile(TAG_ATTRIBUTE_PATTERN), new Color(127, 0, 127));
            patternColors.put(Pattern.compile(TAG_END_PATTERN), new Color(63, 127, 127));
            patternColors.put(Pattern.compile(TAG_ATTRIBUTE_VALUE), new Color(42, 0, 255));
            patternColors.put(Pattern.compile(TAG_COMMENT), new Color(63, 95, 191));
        }
    }

    public static class XmlViewFactory
    implements ViewFactory {
        @Override
        public View create(Element element) {
            return new XmlView(element);
        }
    }

    public static class XmlEditorKit
    extends StyledEditorKit {
        private static final long serialVersionUID = 2969169649596107757L;
        private ViewFactory xmlViewFactory = new XmlViewFactory();

        @Override
        public ViewFactory getViewFactory() {
            return this.xmlViewFactory;
        }

        @Override
        public String getContentType() {
            return "text/xml";
        }
    }

    public static interface ConfigChangeListener {
        public void configChanged(File var1);
    }
}

