/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.matsim.core.utils.io.IOUtils;

class ExeRunner {
    static final Logger log = Logger.getLogger(ExeRunner.class);
    private final ExternalExecutor executor;

    public static ExeRunner run(String[] cmdArgs, JTextArea stdOut, JTextArea errOut, String workingDirectory) {
        ExternalExecutor myExecutor = new ExternalExecutor(cmdArgs, stdOut, errOut, workingDirectory);
        ExeRunner runner = new ExeRunner(myExecutor);
        myExecutor.start();
        return runner;
    }

    private ExeRunner(ExternalExecutor executor) {
        this.executor = executor;
    }

    public void killProcess() {
        this.executor.killProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForFinish() {
        ExternalExecutor externalExecutor = this.executor;
        synchronized (externalExecutor) {
            try {
                this.executor.join();
            }
            catch (InterruptedException e) {
                log.info("Got interrupted while waiting for external exe to finish.", e);
            }
        }
        return this.executor.erg;
    }

    static class StreamHandler
    extends Thread {
        private final BufferedReader in;
        private final JTextArea[] textArea;

        public StreamHandler(BufferedReader in, JTextArea ... textArea) {
            this.in = in;
            this.textArea = textArea;
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.in.readLine()) != null) {
                    for (JTextArea out : this.textArea) {
                        out.append(line);
                        out.append(IOUtils.NATIVE_NEWLINE);
                        int length = out.getDocument().getLength();
                        out.setCaretPosition(length);
                        if (length <= 524288) continue;
                        out.setText(out.getText().substring(262144));
                    }
                }
            }
            catch (IOException e) {
                log.info("StreamHandler got interrupted");
                e.printStackTrace();
            }
        }
    }

    private static class ExternalExecutor
    extends Thread {
        final String[] cmdArgs;
        final JTextArea stdOut;
        final JTextArea errOut;
        final String workingDirectory;
        private Process p = null;
        public int erg = -1;

        public ExternalExecutor(String[] cmdArgs, JTextArea stdOut, JTextArea errOut, String workingDirectory) {
            this.cmdArgs = cmdArgs;
            this.stdOut = stdOut;
            this.errOut = errOut;
            this.workingDirectory = workingDirectory;
        }

        public void killProcess() {
            if (this.p != null) {
                this.p.destroy();
            }
        }

        @Override
        public void run() {
            try {
                this.p = this.workingDirectory == null ? Runtime.getRuntime().exec(this.cmdArgs) : Runtime.getRuntime().exec(this.cmdArgs, null, new File(this.workingDirectory));
                BufferedReader in = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                BufferedReader err = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                StreamHandler outputHandler = new StreamHandler(in, this.stdOut);
                outputHandler.start();
                StreamHandler errorHandler = new StreamHandler(err, this.stdOut, this.errOut);
                errorHandler.start();
                log.info("Starting external exe with command: " + Arrays.toString(this.cmdArgs));
                boolean processRunning = true;
                while (processRunning) {
                    try {
                        this.p.waitFor();
                        this.erg = this.p.exitValue();
                        log.info("external exe returned " + this.erg);
                        processRunning = false;
                    }
                    catch (InterruptedException e) {
                        log.info("Thread waiting for external exe to finish was interrupted");
                        this.erg = -3;
                    }
                }
                try {
                    outputHandler.join();
                }
                catch (InterruptedException e) {
                    log.info("got interrupted while waiting for outputHandler to die.", e);
                }
                try {
                    errorHandler.join();
                }
                catch (InterruptedException e) {
                    log.info("got interrupted while waiting for errorHandler to die.", e);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.erg = -2;
            }
        }
    }
}

