/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.matsim.run.gui.AsyncFileInputProgressDialog;
import org.matsim.run.gui.SaveFileSaver;

class GUnZipper {
    private static final Logger log = Logger.getLogger(GUnZipper.class);

    GUnZipper() {
    }

    public static void gzipFile() {
        JFileChooser chooser = new JFileChooser();
        int openResult = chooser.showOpenDialog(null);
        if (openResult == 0) {
            File srcFile = chooser.getSelectedFile();
            chooser = new SaveFileSaver();
            chooser.setSelectedFile(new File(srcFile.getParentFile(), srcFile.getName() + ".gz"));
            int saveResult = chooser.showSaveDialog(null);
            if (saveResult == 0) {
                File destFile = chooser.getSelectedFile();
                GUnZipper.doGzip(srcFile, destFile);
            }
        }
    }

    public static void gunzipFile() {
        JFileChooser chooser = new JFileChooser();
        int openResult = chooser.showOpenDialog(null);
        if (openResult == 0) {
            File srcFile = chooser.getSelectedFile();
            chooser = new SaveFileSaver();
            chooser.setSelectedFile(new File(srcFile.getParentFile(), srcFile.getName().replace(".gz", "")));
            int saveResult = chooser.showSaveDialog(null);
            if (saveResult == 0) {
                File destFile = chooser.getSelectedFile();
                GUnZipper.doGunzip(srcFile, destFile);
            }
        }
    }

    private static void doGzip(final File srcFile, final File destFile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (FileInputStream srcStream = new FileInputStream(srcFile);
                     FileOutputStream destStream = new FileOutputStream(destFile);
                     BufferedInputStream bSrcStream = new BufferedInputStream(srcStream, 0x400000);
                     BufferedOutputStream bDestStream = new BufferedOutputStream(new GZIPOutputStream((OutputStream)destStream, 65536), 0x400000);
                     AsyncFileInputProgressDialog gui = new AsyncFileInputProgressDialog(srcStream);){
                    GUnZipper.doCopy(bSrcStream, bDestStream);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error while gzipping", 0);
                }
            }
        }, "gzipper").start();
    }

    private static void doGunzip(final File srcFile, final File destFile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (FileInputStream srcStream = new FileInputStream(srcFile);
                     FileOutputStream destStream = new FileOutputStream(destFile);
                     BufferedInputStream bSrcStream = new BufferedInputStream(new GZIPInputStream((InputStream)srcStream, 65536), 0x400000);
                     BufferedOutputStream bDestStream = new BufferedOutputStream(destStream, 0x400000);
                     AsyncFileInputProgressDialog gui = new AsyncFileInputProgressDialog(srcStream);){
                    GUnZipper.doCopy(bSrcStream, bDestStream);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error while gunzipping", 0);
                }
            }
        }, "gunzipper").start();
    }

    private static void doCopy(InputStream src, OutputStream dest) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[65536];
        while ((bytesRead = src.read(buffer)) != -1) {
            dest.write(buffer, 0, bytesRead);
        }
        dest.flush();
    }

    public static void main(String[] args) throws Throwable {
        final JFrame frame = new JFrame();
        frame.setBounds(100, 100, 600, 500);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
                System.out.println("let's go");
                GUnZipper.gzipFile();
                System.out.println("let's continue");
                GUnZipper.gunzipFile();
                System.out.println("and we're done");
                frame.setVisible(false);
            }
        });
    }
}

