/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.run.Controler;
import org.matsim.run.gui.ConfigEditor;
import org.matsim.run.gui.ExeRunner;
import org.matsim.run.gui.GUnZipper;
import org.matsim.run.gui.PopulationSampler;
import org.matsim.run.gui.SaveFileSaver;

public class Gui
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final JLabel lblFilepaths = new JLabel("Filepaths must either be absolute or relative to the location of the config file.");
    private static final JLabel lblJavaLocation = new JLabel("Java Location:");
    private static final JLabel lblConfigurationFile = new JLabel("Configuration file:");
    private static final JLabel lblOutputDirectory = new JLabel("Output Directory:");
    private static final JLabel lblMemory = new JLabel("Memory:");
    private static final JLabel lblMb = new JLabel("MB");
    private static final JLabel lblYouAreUsingJavaVersion = new JLabel("You are using Java version:");
    private static final JLabel lblYouAreUsingMATSimVersion = new JLabel("You are using MATSim version:");
    private JTextField txtConfigfilename;
    private JTextField txtMatsimversion;
    private JTextField txtRam;
    private JTextField txtJvmversion;
    private JTextField txtJvmlocation;
    private JTextField txtOutput;
    private JButton btnStartMatsim;
    private JProgressBar progressBar;
    private JTextArea textStdOut;
    private JScrollPane scrollPane;
    private JButton btnEdit;
    Map<String, JButton> preprocessButtons = new LinkedHashMap<String, JButton>();
    Map<String, JButton> postprocessButtons = new LinkedHashMap<String, JButton>();
    private ExeRunner exeRunner = null;
    private JMenuBar menuBar;
    private JMenu mnTools;
    private JMenuItem mntmCompressFile;
    private JMenuItem mntmUncompressFile;
    private JMenuItem mntmCreateDefaultConfig;
    private JMenuItem mntmCreateSamplePopulation;
    private PopulationSampler popSampler = null;
    private JTextArea textErrOut;
    private final String mainClass;
    private File configFile;
    private File lastUsedDirectory;
    private ConfigEditor editor = null;

    private Gui(String title, Class<?> mainClass) {
        this.setTitle(title);
        this.mainClass = mainClass.getCanonicalName();
    }

    private void createLayout() {
        this.lastUsedDirectory = new File(".");
        this.txtConfigfilename = new JTextField();
        this.txtConfigfilename.setText("");
        this.txtConfigfilename.setColumns(10);
        this.btnStartMatsim = new JButton("Start MATSim");
        this.btnStartMatsim.setEnabled(false);
        for (JButton button : this.preprocessButtons.values()) {
            button.setEnabled(false);
        }
        for (JButton button : this.postprocessButtons.values()) {
            button.setEnabled(false);
        }
        JButton btnChoose = new JButton("Choose");
        btnChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(Gui.this.lastUsedDirectory);
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File f = chooser.getSelectedFile();
                    Gui.this.lastUsedDirectory = f.getParentFile();
                    Gui.this.loadConfigFile(f);
                    if (Gui.this.editor != null) {
                        Gui.this.editor.closeEditor();
                        Gui.this.editor = null;
                    }
                }
            }
        });
        this.btnEdit = new JButton("Edit\u2026");
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(e -> {
            if (this.editor == null) {
                this.editor = new ConfigEditor(this.configFile, this::loadConfigFile);
            }
            this.editor.showEditor();
            this.editor.toFront();
        });
        this.txtMatsimversion = new JTextField();
        this.txtMatsimversion.setEditable(false);
        this.txtMatsimversion.setText(Gbl.getBuildInfoString());
        this.txtMatsimversion.setColumns(10);
        this.txtRam = new JTextField();
        this.txtRam.setText("1024");
        this.txtRam.setColumns(10);
        String javaVersion = System.getProperty("java.version") + "; " + System.getProperty("java.vm.vendor") + "; " + System.getProperty("java.vm.info") + "; " + System.getProperty("sun.arch.data.model") + "-bit";
        this.txtJvmversion = new JTextField();
        this.txtJvmversion.setEditable(false);
        this.txtJvmversion.setText(javaVersion);
        this.txtJvmversion.setColumns(10);
        String jvmLocation = System.getProperty("os.name").startsWith("Win") ? System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe" : System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        this.txtJvmlocation = new JTextField();
        this.txtJvmlocation.setEditable(false);
        this.txtJvmlocation.setText(jvmLocation);
        this.txtJvmlocation.setColumns(10);
        this.txtOutput = new JTextField();
        this.txtOutput.setEditable(false);
        this.txtOutput.setText("");
        this.txtOutput.setColumns(10);
        this.progressBar = new JProgressBar();
        this.progressBar.setEnabled(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.btnStartMatsim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.exeRunner == null) {
                    Gui.this.startMATSim();
                } else {
                    Gui.this.stopMATSim();
                }
            }
        });
        JButton btnOpen = new JButton("Open");
        btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.txtOutput.getText().isEmpty()) {
                    try {
                        File f = new File(Gui.this.txtOutput.getText());
                        Desktop.getDesktop().open(f);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JButton btnDelete = new JButton("Delete");
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                if (!Gui.this.txtOutput.getText().isEmpty() && (i = JOptionPane.showOptionDialog(Gui.this, "Do you really want to delete the output directory? This action cannot be undone.", "Delete Output Directory", -1, 2, null, new String[]{"Cancel", "Delete"}, "Cancel")) == 1) {
                    try {
                        IOUtils.deleteDirectoryRecursively(new File(Gui.this.txtOutput.getText()).toPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane(1);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        GroupLayout.SequentialGroup prebuttonsSequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup prebuttonsParallelGroup = groupLayout.createParallelGroup();
        for (JButton button : this.preprocessButtons.values()) {
            prebuttonsSequentialGroup.addComponent(button);
            prebuttonsParallelGroup.addComponent(button);
        }
        GroupLayout.SequentialGroup postbuttonsSequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup postbuttonsParallelGroup = groupLayout.createParallelGroup();
        for (JButton button : this.postprocessButtons.values()) {
            postbuttonsSequentialGroup.addComponent(button);
            postbuttonsParallelGroup.addComponent(button);
        }
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(tabbedPane, -1, 729, Short.MAX_VALUE).addComponent(lblFilepaths).addGroup(prebuttonsSequentialGroup).addGroup(postbuttonsSequentialGroup).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblYouAreUsingMATSimVersion).addComponent(lblYouAreUsingJavaVersion).addComponent(lblJavaLocation).addComponent(lblConfigurationFile).addComponent(lblOutputDirectory).addComponent(lblMemory).addComponent(this.btnStartMatsim)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtRam, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblMb)).addComponent(this.txtMatsimversion, -1, 285, Short.MAX_VALUE).addComponent(this.txtJvmversion, -1, 285, Short.MAX_VALUE).addComponent(this.txtJvmlocation, -1, 285, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtConfigfilename, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnChoose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEdit)).addComponent(this.progressBar, -1, 285, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtOutput, -1, 112, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnDelete))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblYouAreUsingMATSimVersion).addComponent(this.txtMatsimversion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblYouAreUsingJavaVersion).addComponent(this.txtJvmversion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblJavaLocation).addComponent(this.txtJvmlocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblConfigurationFile).addComponent(this.txtConfigfilename, -2, -1, -2).addComponent(btnChoose).addComponent(this.btnEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblFilepaths).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblOutputDirectory).addComponent(this.txtOutput, -2, -1, -2).addComponent(btnDelete).addComponent(btnOpen)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblMemory).addComponent(this.txtRam, -2, -1, -2).addComponent(lblMb)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(prebuttonsParallelGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStartMatsim).addComponent(this.progressBar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(postbuttonsParallelGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(tabbedPane, -1, 180, Short.MAX_VALUE).addContainerGap()));
        this.textStdOut = new JTextArea();
        this.textStdOut.setWrapStyleWord(true);
        this.textStdOut.setTabSize(4);
        this.textStdOut.setEditable(false);
        this.scrollPane = new JScrollPane(this.textStdOut);
        tabbedPane.addTab("Output", null, this.scrollPane, null);
        JScrollPane scrollPane_1 = new JScrollPane();
        tabbedPane.addTab("Warnings & Errors", null, scrollPane_1, null);
        this.textErrOut = new JTextArea();
        this.textErrOut.setWrapStyleWord(true);
        this.textErrOut.setTabSize(4);
        this.textErrOut.setEditable(false);
        scrollPane_1.setViewportView(this.textErrOut);
        this.getContentPane().setLayout(groupLayout);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.mnTools = new JMenu("Tools");
        this.menuBar.add(this.mnTools);
        this.mntmCompressFile = new JMenuItem("Compress File\u2026");
        this.mnTools.add(this.mntmCompressFile);
        this.mntmCompressFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUnZipper.gzipFile();
            }
        });
        this.mntmUncompressFile = new JMenuItem("Uncompress File\u2026");
        this.mnTools.add(this.mntmUncompressFile);
        this.mntmUncompressFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUnZipper.gunzipFile();
            }
        });
        this.mnTools.addSeparator();
        this.mntmCreateDefaultConfig = new JMenuItem("Create Default config.xml\u2026");
        this.mnTools.add(this.mntmCreateDefaultConfig);
        this.mntmCreateDefaultConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveFileSaver chooser = new SaveFileSaver();
                chooser.setSelectedFile(new File("defaultConfig.xml"));
                int saveResult = chooser.showSaveDialog(null);
                if (saveResult == 0) {
                    File destFile = chooser.getSelectedFile();
                    Config config = ConfigUtils.createConfig();
                    new ConfigWriter(config).write(destFile.getAbsolutePath());
                }
            }
        });
        this.mntmCreateSamplePopulation = new JMenuItem("Create Sample Population\u2026");
        this.mnTools.add(this.mntmCreateSamplePopulation);
        this.mntmCreateSamplePopulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.popSampler == null) {
                    Gui.this.popSampler = new PopulationSampler();
                    Gui.this.popSampler.pack();
                }
                Gui.this.popSampler.setVisible(true);
            }
        });
    }

    public void startMATSim() {
        this.progressBar.setVisible(true);
        this.progressBar.setEnabled(true);
        this.btnStartMatsim.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String classpath = System.getProperty("java.class.path");
                String[] cpParts = classpath.split(File.pathSeparator);
                StringBuilder absoluteClasspath = new StringBuilder();
                for (String cpPart : cpParts) {
                    if (absoluteClasspath.length() > 0) {
                        absoluteClasspath.append(File.pathSeparatorChar);
                    }
                    absoluteClasspath.append(new File(cpPart).getAbsolutePath());
                }
                String[] cmdArgs = new String[]{Gui.this.txtJvmlocation.getText(), "-cp", absoluteClasspath.toString(), "-Xmx" + Gui.this.txtRam.getText() + "m", Gui.this.mainClass, Gui.this.txtConfigfilename.getText()};
                Gui.this.textStdOut.setText("");
                Gui.this.textErrOut.setText("");
                Gui.this.exeRunner = ExeRunner.run(cmdArgs, Gui.this.textStdOut, Gui.this.textErrOut, new File(Gui.this.txtConfigfilename.getText()).getParent());
                Gui.this.btnStartMatsim.setText("Stop MATSim");
                Gui.this.btnStartMatsim.setEnabled(true);
                int exitcode = Gui.this.exeRunner.waitForFinish();
                Gui.this.exeRunner = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Gui.this.progressBar.setVisible(false);
                        Gui.this.btnStartMatsim.setText("Start MATSim");
                        Gui.this.btnStartMatsim.setEnabled(true);
                    }
                });
                if (exitcode != 0) {
                    Gui.this.textStdOut.append("\n");
                    Gui.this.textStdOut.append("The simulation did not run properly. Error/Exit code: " + exitcode);
                    Gui.this.textStdOut.setCaretPosition(Gui.this.textStdOut.getDocument().getLength());
                    Gui.this.textErrOut.append("\n");
                    Gui.this.textErrOut.append("The simulation did not run properly. Error/Exit code: " + exitcode);
                    Gui.this.textErrOut.setCaretPosition(Gui.this.textStdOut.getDocument().getLength());
                    throw new RuntimeException("There was a problem running MATSim. exit code: " + exitcode);
                }
            }
        }).start();
    }

    public void loadConfigFile(File configFile) {
        this.configFile = configFile;
        String configFilename = configFile.getAbsolutePath();
        Config config = ConfigUtils.createConfig();
        try {
            ConfigUtils.loadConfig(config, configFilename);
        }
        catch (Exception e) {
            this.textStdOut.setText("");
            this.textStdOut.append("The configuration file could not be loaded. Error message:\n");
            this.textStdOut.append(e.getMessage());
            this.textErrOut.setText("");
            this.textErrOut.append("The configuration file could not be loaded. Error message:\n");
            this.textErrOut.append(e.getMessage());
            return;
        }
        this.txtConfigfilename.setText(configFilename);
        File par = configFile.getParentFile();
        File outputDir = new File(par, config.controler().getOutputDirectory());
        try {
            this.txtOutput.setText(outputDir.getCanonicalPath());
        }
        catch (IOException e1) {
            this.txtOutput.setText(outputDir.getAbsolutePath());
        }
        this.btnStartMatsim.setEnabled(true);
        this.btnEdit.setEnabled(true);
        for (JButton button : this.preprocessButtons.values()) {
            button.setEnabled(true);
        }
        for (JButton button : this.postprocessButtons.values()) {
            button.setEnabled(true);
        }
    }

    public void stopMATSim() {
        ExeRunner runner = this.exeRunner;
        if (runner != null) {
            runner.killProcess();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Gui.this.progressBar.setVisible(false);
                    Gui.this.btnStartMatsim.setText("Start MATSim");
                    Gui.this.btnStartMatsim.setEnabled(true);
                    Gui.this.textStdOut.append("\n");
                    Gui.this.textStdOut.append("The simulation was stopped forcefully.");
                    Gui.this.textStdOut.setCaretPosition(Gui.this.textStdOut.getDocument().getLength());
                    Gui.this.textErrOut.append("\n");
                    Gui.this.textErrOut.append("The simulation was stopped forcefully.");
                    Gui.this.textErrOut.setCaretPosition(Gui.this.textStdOut.getDocument().getLength());
                }
            });
        }
    }

    public static Gui show(String title, Class<?> mainClass) {
        Gui gui = Gui.create(title, mainClass);
        gui.run();
        return gui;
    }

    public void run() {
        this.createLayout();
        this.pack();
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    public static Gui create(String title, Class<?> mainClass) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        return new Gui(title, mainClass);
    }

    public static void main(String[] args) {
        File configFile;
        Gui gui = Gui.show("MATSim", Controler.class);
        if (args.length > 0 && (configFile = new File(args[0])).exists()) {
            gui.loadConfigFile(configFile);
        }
    }

    final JMenu getToolsMenu() {
        return this.mnTools;
    }

    final void addToMenuBar(JMenu menuItem) {
        this.menuBar.add(menuItem);
    }

    final void addPreprocessButton(String str, JButton button) {
        this.preprocessButtons.put(str, button);
    }

    final void addPostprocessButton(String str, JButton button) {
        this.postprocessButtons.put(str, button);
    }

    JTextArea getTextStdOut() {
        return this.textStdOut;
    }

    JTextArea getTextErrOut() {
        return this.textErrOut;
    }

    JTextField getTxtJvmlocation() {
        return this.txtJvmlocation;
    }

    JTextField getTxtRam() {
        return this.txtRam;
    }

    JTextField getTxtConfigfilename() {
        return this.txtConfigfilename;
    }
}

