/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.run.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.population.io.StreamingDeprecated;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.population.io.StreamingPopulationWriter;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.io.UnicodeInputStream;
import org.matsim.run.gui.AsyncFileInputProgressDialog;
import org.matsim.run.gui.SaveFileSaver;

public final class PopulationSampler
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField txtPath;
    private JSpinner pctSpinner;
    private JButton btnChoose;
    private JButton btnCreateSample;

    public PopulationSampler() {
        this.setTitle("Create Population Sample");
        this.btnChoose = new JButton("Choose\u2026");
        JLabel lblinput = new JLabel("Input Population:");
        this.txtPath = new JTextField("");
        JLabel lblpercentage = new JLabel("Sample Size:");
        this.pctSpinner = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
        JLabel lblPercentage = new JLabel("%");
        this.btnCreateSample = new JButton("Create Sample\u2026");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblinput).addComponent(lblpercentage)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.pctSpinner, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblPercentage, -1, -2, -1).addGap(0, 20, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtPath, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChoose)))).addComponent(this.btnCreateSample, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnChoose).addComponent(lblinput).addComponent(this.txtPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblpercentage).addComponent(lblPercentage).addComponent(this.pctSpinner)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCreateSample).addContainerGap()));
        this.getContentPane().setLayout(groupLayout);
        this.setupComponents();
    }

    private void setupComponents() {
        this.btnChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File f = chooser.getSelectedFile();
                    String filename = f.getAbsolutePath();
                    PopulationSampler.this.txtPath.setText(filename);
                }
            }
        });
        this.btnCreateSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PopulationSampler.this.createSample();
                    }
                }, "SampleCreator").start();
                PopulationSampler.this.setVisible(false);
            }
        });
    }

    private void createSample() {
        block6: {
            String srcFilename = this.txtPath.getText();
            File srcFile = new File(srcFilename);
            if (!srcFile.exists()) {
                JOptionPane.showMessageDialog(null, "The specified file could not be found: " + srcFilename, "File not found!", 0);
                return;
            }
            String namePart = srcFilename.substring(0, srcFilename.toLowerCase(Locale.ROOT).lastIndexOf(".xml"));
            int percentage = (Integer)this.pctSpinner.getValue();
            double samplesize = (double)percentage / 100.0;
            SaveFileSaver chooser = new SaveFileSaver();
            chooser.setCurrentDirectory(srcFile.getParentFile());
            chooser.setSelectedFile(new File(srcFile.getParentFile(), namePart + "." + Integer.toString(percentage) + "pct.xml.gz"));
            int saveResult = chooser.showSaveDialog(this);
            if (saveResult == 0) {
                File destFile = chooser.getSelectedFile();
                try {
                    PopulationSampler.createSample(srcFile, null, samplesize, destFile);
                }
                catch (IOException | RuntimeException ex) {
                    destFile.delete();
                    JOptionPane.showMessageDialog(null, "<html>It looks like the population file cannot be parsed without a network file.<br />Please select a matching network file in the next dialog.</html>", "Problems creating pouplation sample", 2);
                    JFileChooser netChooser = new JFileChooser();
                    netChooser.setCurrentDirectory(srcFile.getParentFile());
                    int result = netChooser.showOpenDialog(this);
                    if (result != 0) break block6;
                    File networkFile = netChooser.getSelectedFile();
                    try {
                        PopulationSampler.createSample(srcFile, networkFile, samplesize, destFile);
                    }
                    catch (IOException | RuntimeException ex2) {
                        destFile.delete();
                        JOptionPane.showMessageDialog(null, "The population sample cannot be created, as not all necessary data is available.", "Cannot create population sample", 0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSample(File inputPopulationFile, File networkFile, double samplesize, File outputPopulationFile) throws RuntimeException, IOException {
        MutableScenario sc = ScenarioUtils.createMutableScenario(ConfigUtils.createConfig());
        if (networkFile != null) {
            try (FileInputStream fis = new FileInputStream(networkFile);
                 BufferedInputStream is = networkFile.getName().toLowerCase(Locale.ROOT).endsWith(".gz") ? new BufferedInputStream(new UnicodeInputStream(new GZIPInputStream(fis))) : new BufferedInputStream(new UnicodeInputStream(fis));
                 AsyncFileInputProgressDialog gui = new AsyncFileInputProgressDialog(fis, "Loading Network\u2026");){
                new MatsimNetworkReader(sc.getNetwork()).parse(is);
            }
        }
        StreamingPopulationReader reader = new StreamingPopulationReader(sc);
        StreamingDeprecated.setIsStreaming(reader, true);
        StreamingPopulationWriter writer = null;
        try {
            writer = new StreamingPopulationWriter(null, samplesize);
            writer.startStreaming(outputPopulationFile.getAbsolutePath());
            StreamingPopulationWriter algo = writer;
            reader.addAlgorithm(algo);
            try (FileInputStream fis = new FileInputStream(inputPopulationFile);
                 BufferedInputStream is = inputPopulationFile.getName().toLowerCase(Locale.ROOT).endsWith(".gz") ? new BufferedInputStream(new UnicodeInputStream(new GZIPInputStream(fis))) : new BufferedInputStream(new UnicodeInputStream(fis));
                 AsyncFileInputProgressDialog gui = new AsyncFileInputProgressDialog(fis, "Creating Population Sample\u2026");){
                reader.parse(is);
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.closeStreaming();
            }
        }
    }
}

