/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.eventsfilecomparison;

import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;
import org.matsim.utils.eventsfilecomparison.Counter;
import org.matsim.utils.eventsfilecomparison.Worker;

public final class EventsFileComparator {
    private static final Logger log = Logger.getLogger(EventsFileComparator.class);
    @Deprecated
    public static final int CODE_FILES_ARE_EQUAL = 0;
    @Deprecated
    public static final int CODE_DIFFERENT_NUMBER_OF_TIMESTEPS = -1;
    @Deprecated
    public static final int CODE_DIFFERENT_TIMESTEPS = -2;
    @Deprecated
    public static final int CODE_MISSING_EVENT = -3;
    @Deprecated
    public static final int CODE_WRONG_EVENT_COUNT = -4;

    private EventsFileComparator() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Error: expected 2 events files as input arguments but found " + args.length);
            System.out.println("Syntax: EventsFileComparator eventsFile1 eventsFile2");
        } else {
            String filename1 = args[0];
            String filename2 = args[1];
            EventsFileComparator.compareAndReturnInt(filename1, filename2);
        }
    }

    @Deprecated
    public static int compareAndReturnInt(String filename1, String filename2) {
        Result result = EventsFileComparator.compare(filename1, filename2);
        switch (result) {
            case DIFFERENT_NUMBER_OF_TIMESTEPS: {
                return -1;
            }
            case DIFFERENT_TIMESTEPS: {
                return -2;
            }
            case FILES_ARE_EQUAL: {
                return 0;
            }
            case MISSING_EVENT: {
                return -3;
            }
            case WRONG_EVENT_COUNT: {
                return -4;
            }
        }
        throw new RuntimeException("unknown Result code");
    }

    public static Result compare(String filename1, String filename2) {
        EventsComparator comparator = new EventsComparator();
        CyclicBarrier doComparison = new CyclicBarrier(2, comparator);
        Worker w1 = new Worker(filename1, doComparison);
        Worker w2 = new Worker(filename2, doComparison);
        comparator.setWorkers(w1, w2);
        w1.start();
        w2.start();
        try {
            w1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            w2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Result retCode = comparator.retCode;
        if (retCode == Result.FILES_ARE_EQUAL) {
            log.info("Event files are semantic equivalent.");
        } else {
            log.warn("Event files differ.");
        }
        return retCode;
    }

    static class EventsComparator
    implements Runnable {
        private Worker worker1 = null;
        private Worker worker2 = null;
        volatile Result retCode = null;

        EventsComparator() {
        }

        void setWorkers(Worker w1, Worker w2) {
            this.worker1 = w1;
            this.worker2 = w2;
        }

        @Override
        public void run() {
            Counter c;
            if (this.worker1.getCurrentTime() != this.worker2.getCurrentTime()) {
                log.warn("Differnt time steps in event files!");
                this.setExitCode(Result.DIFFERENT_TIMESTEPS);
                return;
            }
            if (this.worker1.isFinished() != this.worker2.isFinished()) {
                log.warn("Events files have different number of time steps!");
                this.setExitCode(Result.DIFFERENT_NUMBER_OF_TIMESTEPS);
                return;
            }
            Map<String, Counter> map1 = this.worker1.getEventsMap();
            Map<String, Counter> map2 = this.worker2.getEventsMap();
            for (Map.Entry<String, Counter> e : map1.entrySet()) {
                c = map2.get(e.getKey());
                if (c == null) {
                    log.warn("The event:");
                    log.warn(e.getKey());
                    log.warn("is missing in events file:" + this.worker2.getEventsFile());
                    this.setExitCode(Result.MISSING_EVENT);
                    return;
                }
                if (c.getCount() == e.getValue().getCount()) continue;
                log.warn("Wrong event count for: " + e.getKey() + "\n" + e.getValue().getCount() + " times in file:" + this.worker1.getEventsFile() + "\n" + c.getCount() + " times in file:" + this.worker2.getEventsFile());
                this.setExitCode(Result.WRONG_EVENT_COUNT);
                return;
            }
            for (Map.Entry<String, Counter> e : map2.entrySet()) {
                c = map1.get(e.getKey());
                if (c != null) continue;
                log.warn("The event:");
                log.warn(e.getKey());
                log.warn("is missing in events file:" + this.worker1.getEventsFile());
                this.setExitCode(Result.MISSING_EVENT);
                return;
            }
            if (this.worker1.isFinished()) {
                this.setExitCode(Result.FILES_ARE_EQUAL);
            }
        }

        private void setExitCode(Result errCode) {
            this.retCode = errCode;
            if (errCode != Result.FILES_ARE_EQUAL) {
                this.worker1.interrupt();
                this.worker2.interrupt();
            }
        }
    }

    public static enum Result {
        FILES_ARE_EQUAL,
        DIFFERENT_NUMBER_OF_TIMESTEPS,
        DIFFERENT_TIMESTEPS,
        MISSING_EVENT,
        WRONG_EVENT_COUNT;

    }
}

