/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.eventsfilecomparison;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.events.EventsUtils;
import org.matsim.core.events.MatsimEventsReader;
import org.matsim.core.events.handler.BasicEventHandler;
import org.matsim.utils.eventsfilecomparison.Counter;

public class Worker
extends Thread
implements BasicEventHandler {
    private static final Logger log = Logger.getLogger(Worker.class);
    private final EventsManager eventsManager;
    private final String eFile;
    private final CyclicBarrier doComparison;
    private final Map<String, Counter> events = new HashMap<String, Counter>();
    private volatile double time = -1.0;
    private volatile boolean finished = false;
    private volatile int numEvents = 0;

    public Worker(String eFile1, CyclicBarrier doComparison) {
        this.eFile = eFile1;
        this.doComparison = doComparison;
        this.eventsManager = EventsUtils.createEventsManager();
        this.eventsManager.addHandler(this);
    }

    String getEventsFile() {
        return this.eFile;
    }

    @Override
    public void run() {
        try {
            new MatsimEventsReader(this.eventsManager).readFile(this.eFile);
            this.finished = true;
            try {
                this.doComparison.await();
            }
            catch (InterruptedException e1) {
                throw new ComparatorInterruptedException(e1);
            }
            catch (BrokenBarrierException e1) {
                throw new ComparatorInterruptedException(e1);
            }
        }
        catch (ComparatorInterruptedException e1) {
            log.info("events-comparator got interrupted");
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Map<String, Counter> getEventsMap() {
        return this.events;
    }

    public double getCurrentTime() {
        return this.time;
    }

    @Override
    public void reset(int iteration) {
    }

    @Override
    public void handleEvent(Event event) {
        if (this.time != event.getTime()) {
            try {
                this.doComparison.await();
            }
            catch (InterruptedException e1) {
                throw new ComparatorInterruptedException(e1);
            }
            catch (BrokenBarrierException e1) {
                throw new ComparatorInterruptedException(e1);
            }
            this.events.clear();
            this.time = event.getTime();
            this.numEvents = 0;
        }
        this.addEvent(event);
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    private void addEvent(Event event) {
        ++this.numEvents;
        String lexString = this.toLexicographicSortedString(event);
        Counter counter = this.events.get(lexString);
        if (counter == null) {
            counter = new Counter();
            this.events.put(lexString, counter);
        }
        counter.increment();
    }

    private String toLexicographicSortedString(Event event) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Map.Entry<String, String> e : event.getAttributes().entrySet()) {
            StringBuilder tmp = new StringBuilder();
            tmp.append(e.getKey());
            tmp.append("=");
            tmp.append(e.getValue());
            strings.add(tmp.toString());
        }
        Collections.sort(strings);
        StringBuilder eventStr = new StringBuilder();
        for (String str : strings) {
            eventStr.append("|");
            eventStr.append(str);
        }
        return eventStr.toString();
    }

    private static class ComparatorInterruptedException
    extends RuntimeException {
        public ComparatorInterruptedException(Exception e) {
            super(e);
        }
    }
}

