/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.matsim.utils.gis.matsim2esri.network.FeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.FeatureGeneratorBuilder;
import org.matsim.utils.gis.matsim2esri.network.LanesBasedWidthCalculator;
import org.matsim.utils.gis.matsim2esri.network.PolygonFeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.WidthCalculator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureGeneratorBuilderImpl
implements FeatureGeneratorBuilder {
    private final Network network;
    private CoordinateReferenceSystem crs;
    private Constructor<? extends FeatureGenerator> featureGeneratorPrototypeContructor;
    private static final Class[] FEATURE_GENERATOR_PROTOTYPECONSTRUCTOR = new Class[]{WidthCalculator.class, CoordinateReferenceSystem.class};
    private Constructor<? extends WidthCalculator> widthCalculatorPrototypeContructor;
    private double widthCoefficient = 1.0;
    private static final Class[] WIDTH_CALCULATOR_PROTOTYPECONSTRUCTOR = new Class[]{Network.class, Double.class};

    public FeatureGeneratorBuilderImpl(Network network, String coordinateSystem) {
        this.network = network;
        this.crs = MGC.getCRS(coordinateSystem);
        try {
            this.featureGeneratorPrototypeContructor = PolygonFeatureGenerator.class.getConstructor(FEATURE_GENERATOR_PROTOTYPECONSTRUCTOR);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            this.widthCalculatorPrototypeContructor = LanesBasedWidthCalculator.class.getConstructor(WIDTH_CALCULATOR_PROTOTYPECONSTRUCTOR);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FeatureGenerator createFeatureGenerator() {
        Exception ex;
        WidthCalculator widthCalc = this.createWidthCalculator();
        try {
            FeatureGenerator ret = this.featureGeneratorPrototypeContructor.newInstance(widthCalc, this.crs);
            return ret;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new RuntimeException("Could not instantiate feature generator from prototype! " + this.featureGeneratorPrototypeContructor.getDeclaringClass().getCanonicalName(), ex);
    }

    private WidthCalculator createWidthCalculator() {
        Exception ex;
        try {
            WidthCalculator ret = this.widthCalculatorPrototypeContructor.newInstance(this.network, this.widthCoefficient);
            return ret;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new RuntimeException("Could not instantiate width calculator from prototype!", ex);
    }

    public void setWidthCoefficient(double coef) {
        this.widthCoefficient = coef;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setWidthCalculatorPrototype(Class<? extends WidthCalculator> prototype) {
        try {
            Constructor<? extends WidthCalculator> c = prototype.getConstructor(WIDTH_CALCULATOR_PROTOTYPECONSTRUCTOR);
            if (null == c) {
                throw new IllegalArgumentException("Wrong prototype constructor!");
            }
            this.widthCalculatorPrototypeContructor = c;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void setFeatureGeneratorPrototype(Class<? extends FeatureGenerator> prototype) {
        try {
            Constructor<? extends FeatureGenerator> c = prototype.getConstructor(FEATURE_GENERATOR_PROTOTYPECONSTRUCTOR);
            if (null == c) {
                throw new IllegalArgumentException("Wrong prototype constructor!");
            }
            this.featureGeneratorPrototypeContructor = c;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

