/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.utils.gis.matsim2esri.network.WidthCalculator;

public class LanesBasedWidthCalculator
implements WidthCalculator {
    private static final Logger log = Logger.getLogger(LanesBasedWidthCalculator.class);
    private final double effectiveLaneWidth;
    private final double widthCoefficient;

    public LanesBasedWidthCalculator(Network network, Double coef) {
        double w = network.getEffectiveLaneWidth();
        if (Double.isNaN(w)) {
            log.warn("Effective lane width in network is set to Double.NaN. Set a real value in your network.xml to make this tool work with this value. Using 3.75 as effective lane width...");
            this.effectiveLaneWidth = 3.75;
        } else {
            this.effectiveLaneWidth = w;
        }
        this.widthCoefficient = coef;
    }

    @Override
    public double getWidth(Link link) {
        return link.getNumberOfLanes() * this.effectiveLaneWidth * this.widthCoefficient;
    }
}

