/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.matsim.utils.gis.matsim2esri.network.FeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.WidthCalculator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LineStringBasedFeatureGenerator
implements FeatureGenerator {
    private final WidthCalculator widthCalculator;
    private SimpleFeatureBuilder builder;
    private final CoordinateReferenceSystem crs;
    private final GeometryFactory geofac;

    public LineStringBasedFeatureGenerator(WidthCalculator widthCalculator, CoordinateReferenceSystem crs) {
        this.widthCalculator = widthCalculator;
        this.crs = crs;
        this.geofac = new GeometryFactory();
        this.initFeatureType();
    }

    private void initFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("link");
        typeBuilder.setCRS(this.crs);
        typeBuilder.add("the_geom", LineString.class);
        typeBuilder.add("ID", String.class);
        typeBuilder.add("fromID", String.class);
        typeBuilder.add("toID", String.class);
        typeBuilder.add("length", Double.class);
        typeBuilder.add("freespeed", Double.class);
        typeBuilder.add("capacity", Double.class);
        typeBuilder.add("lanes", Double.class);
        typeBuilder.add("visWidth", Double.class);
        typeBuilder.add("type", String.class);
        this.builder = new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    @Override
    public SimpleFeature getFeature(Link link) {
        double width = this.widthCalculator.getWidth(link);
        LineString ls = this.geofac.createLineString(new Coordinate[]{MGC.coord2Coordinate(link.getFromNode().getCoord()), MGC.coord2Coordinate(link.getToNode().getCoord())});
        Object[] attribs = new Object[]{ls, link.getId().toString(), link.getFromNode().getId().toString(), link.getToNode().getId().toString(), link.getLength(), link.getFreespeed(), link.getCapacity(), link.getNumberOfLanes(), width, NetworkUtils.getType(link)};
        try {
            return this.builder.buildFeature(null, attribs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

