/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.matsim.core.utils.gis.ShapeFileWriter;
import org.matsim.utils.gis.matsim2esri.network.CapacityBasedWidthCalculator;
import org.matsim.utils.gis.matsim2esri.network.FeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.FeatureGeneratorBuilder;
import org.matsim.utils.gis.matsim2esri.network.FeatureGeneratorBuilderImpl;
import org.matsim.utils.gis.matsim2esri.network.LanesBasedWidthCalculator;
import org.matsim.utils.gis.matsim2esri.network.LineStringBasedFeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.PolygonFeatureGenerator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Links2ESRIShape {
    private static Logger log = Logger.getLogger(Links2ESRIShape.class);
    private final FeatureGenerator featureGenerator;
    private final Network network;
    private final String filename;

    public Links2ESRIShape(Network network, String filename, String coordinateSystem) {
        this(network, filename, new FeatureGeneratorBuilderImpl(network, coordinateSystem));
    }

    public Links2ESRIShape(Network network, String filename, FeatureGeneratorBuilder builder) {
        this.network = network;
        this.filename = filename;
        this.featureGenerator = builder.createFeatureGenerator();
    }

    public void write() {
        log.info("creating features...");
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (Link link : NetworkUtils.getSortedLinks(this.network)) {
            features.add(this.featureGenerator.getFeature(link));
        }
        log.info("writing features to shape file... " + this.filename);
        ShapeFileWriter.writeGeometries(features, this.filename);
        log.info("done writing shape file.");
    }

    public static void main(String[] args) {
        String netfile = null;
        String outputFileLs = null;
        String outputFileP = null;
        String defaultCRS = "DHDN_GK4";
        boolean commonWealth = false;
        if (args.length == 0) {
            netfile = "./examples/equil/network.xml";
            outputFileLs = "./plans/networkLs.shp";
            outputFileP = "./plans/networkP.shp";
        } else if (args.length == 3) {
            netfile = args[0];
            outputFileLs = args[1];
            outputFileP = args[2];
        } else if (args.length == 4) {
            netfile = args[0];
            outputFileLs = args[1];
            outputFileP = args[2];
            defaultCRS = args[3];
        } else if (args.length == 5) {
            netfile = args[0];
            outputFileLs = args[1];
            outputFileP = args[2];
            defaultCRS = args[3];
            commonWealth = Boolean.parseBoolean(args[4]);
        } else {
            log.error("Arguments cannot be interpreted.  Aborting ...");
            System.exit(-1);
        }
        Scenario scenario = ScenarioUtils.createScenario(ConfigUtils.createConfig());
        scenario.getConfig().global().setCoordinateSystem(defaultCRS);
        log.info("loading network from " + netfile);
        Network network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile(netfile);
        log.info("done.");
        FeatureGeneratorBuilderImpl builder = new FeatureGeneratorBuilderImpl(network, defaultCRS);
        builder.setFeatureGeneratorPrototype(LineStringBasedFeatureGenerator.class);
        builder.setWidthCoefficient(0.5);
        builder.setWidthCalculatorPrototype(LanesBasedWidthCalculator.class);
        new Links2ESRIShape(network, outputFileLs, builder).write();
        CoordinateReferenceSystem crs = MGC.getCRS(defaultCRS);
        builder.setWidthCoefficient((double)(commonWealth ? -1 : 1) * 0.003);
        builder.setFeatureGeneratorPrototype(PolygonFeatureGenerator.class);
        builder.setWidthCalculatorPrototype(CapacityBasedWidthCalculator.class);
        builder.setCoordinateReferenceSystem(crs);
        new Links2ESRIShape(network, outputFileP, builder).write();
    }
}

