/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Point;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.matsim.core.utils.gis.ShapeFileWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Nodes2ESRIShape {
    private static final Logger log = Logger.getLogger(Nodes2ESRIShape.class);
    private final Network network;
    private final String filename;
    private SimpleFeatureBuilder builder;

    public Nodes2ESRIShape(Network network, String filename, String coordinateSystem) {
        this(network, filename, MGC.getCRS(coordinateSystem));
    }

    public Nodes2ESRIShape(Network network, String filename, CoordinateReferenceSystem crs) {
        this.network = network;
        this.filename = filename;
        this.initFeatureType(crs);
    }

    public void write() {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (Node node : NetworkUtils.getSortedNodes(this.network)) {
            features.add(this.getFeature(node));
        }
        ShapeFileWriter.writeGeometries(features, this.filename);
    }

    private SimpleFeature getFeature(Node node) {
        Point p = MGC.coord2Point(node.getCoord());
        try {
            return this.builder.buildFeature(null, new Object[]{p, node.getId().toString()});
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void initFeatureType(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("node");
        typeBuilder.setCRS(crs);
        typeBuilder.add("location", Point.class);
        typeBuilder.add("ID", String.class);
        this.builder = new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    public static void main(String[] args) {
        String netfile = null;
        String outputFile = null;
        if (args.length == 0) {
            netfile = "./examples/equil/network.xml";
            outputFile = "./plans/networkNodes.shp";
        } else if (args.length == 2) {
            netfile = args[0];
            outputFile = args[1];
        } else {
            log.error("Arguments cannot be interpreted.  Aborting ...");
            System.exit(-1);
        }
        MutableScenario scenario = (MutableScenario)ScenarioUtils.createScenario(ConfigUtils.createConfig());
        log.info("loading network from " + netfile);
        Network network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile(netfile);
        log.info("done.");
        new Nodes2ESRIShape(network, outputFile, "DHDN_GK4").write();
    }
}

