/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.gis.matsim2esri.network;

import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.matsim.utils.gis.matsim2esri.network.FeatureGenerator;
import org.matsim.utils.gis.matsim2esri.network.WidthCalculator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PolygonFeatureGenerator
implements FeatureGenerator {
    private static final double PI_HALF = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private final WidthCalculator widthCalculator;
    private final CoordinateReferenceSystem crs;
    private final GeometryFactory geofac;
    private SimpleFeatureBuilder builder;

    public PolygonFeatureGenerator(WidthCalculator widthCalculator, CoordinateReferenceSystem crs) {
        this.widthCalculator = widthCalculator;
        this.crs = crs;
        this.geofac = new GeometryFactory();
        this.initFeatureType();
    }

    private void initFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("link");
        typeBuilder.setCRS(this.crs);
        typeBuilder.add("the_geom", Polygon.class);
        typeBuilder.add("ID", String.class);
        typeBuilder.add("fromID", String.class);
        typeBuilder.add("toID", String.class);
        typeBuilder.add("length", Double.class);
        typeBuilder.add("freespeed", Double.class);
        typeBuilder.add("capacity", Double.class);
        typeBuilder.add("lanes", Double.class);
        typeBuilder.add("visWidth", Double.class);
        this.builder = new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    @Override
    public SimpleFeature getFeature(Link link) {
        double width = this.widthCalculator.getWidth(link);
        Coordinate[] coords = PolygonFeatureGenerator.createPolygonCoordsForLink(link, width);
        Polygon p = this.geofac.createPolygon(this.geofac.createLinearRing(coords), null);
        Object[] attribs = new Object[]{p, link.getId().toString(), link.getFromNode().getId().toString(), link.getToNode().getId().toString(), link.getLength(), link.getFreespeed(), link.getCapacity(), link.getNumberOfLanes(), width};
        try {
            return this.builder.buildFeature(null, attribs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static Coordinate[] createPolygonCoordsForLink(Link link, double width) {
        Coordinate from = MGC.coord2Coordinate(link.getFromNode().getCoord());
        Coordinate to = MGC.coord2Coordinate(link.getToNode().getCoord());
        double length = from.distance(to);
        double dx = -from.x + to.x;
        double dy = -from.y + to.y;
        double theta = 0.0;
        theta = dx > 0.0 ? Math.atan(dy / dx) : (dx < 0.0 ? Math.PI + Math.atan(dy / dx) : (dy > 0.0 ? 1.5707963267948966 : -1.5707963267948966));
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double xfrom2 = from.x + sinTheta * width;
        double yfrom2 = from.y - cosTheta * width;
        double xto2 = from.x + cosTheta * length + sinTheta * width;
        double yto2 = from.y + sinTheta * length - cosTheta * width;
        Coordinate from2 = new Coordinate(xfrom2, yfrom2);
        Coordinate to2 = new Coordinate(xto2, yto2);
        return new Coordinate[]{from, to, to2, from2, from};
    }
}

