/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.leastcostpathtree;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.router.costcalculators.RandomizingTimeDistanceTravelDisutilityFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.trafficmonitoring.TravelTimeCalculator;
import org.matsim.core.utils.misc.Time;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleUtils;

public class LeastCostPathTree {
    private Node origin1 = null;
    private double dTime = Time.getUndefinedTime();
    private final TravelTime ttFunction;
    private final TravelDisutility tcFunction;
    private HashMap<Id<Node>, NodeData> nodeData = null;
    private final Vehicle VEHICLE = VehicleUtils.getFactory().createVehicle(Id.create("theVehicle", Vehicle.class), VehicleUtils.getDefaultVehicleType());
    private final Person PERSON = PopulationUtils.getFactory().createPerson(Id.create("thePerson", Person.class));

    public LeastCostPathTree(TravelTime tt, TravelDisutility tc) {
        this.ttFunction = tt;
        this.tcFunction = tc;
    }

    public void calculate(Network network, Node origin, double time) {
        this.origin1 = origin;
        this.dTime = time;
        this.nodeData = new HashMap((int)((double)network.getNodes().size() * 1.1), 0.95f);
        NodeData d = new NodeData();
        d.time = time;
        d.cost = 0.0;
        this.nodeData.put(origin.getId(), d);
        ComparatorCost comparator = new ComparatorCost(this.nodeData);
        PriorityQueue<Node> pendingNodes = new PriorityQueue<Node>(500, comparator);
        this.relaxNode(origin, pendingNodes);
        while (!pendingNodes.isEmpty()) {
            Node n = pendingNodes.poll();
            this.relaxNode(n, pendingNodes);
        }
    }

    public final Map<Id<Node>, NodeData> getTree() {
        return this.nodeData;
    }

    public final Node getOrigin() {
        return this.origin1;
    }

    public final double getDepartureTime() {
        return this.dTime;
    }

    private void relaxNode(Node n, PriorityQueue<Node> pendingNodes) {
        NodeData nData = this.nodeData.get(n.getId());
        double currTime = nData.getTime();
        double currCost = nData.getCost();
        for (Link link : n.getOutLinks().values()) {
            Node nn = link.getToNode();
            NodeData nnData = this.nodeData.get(nn.getId());
            if (nnData == null) {
                nnData = new NodeData();
                this.nodeData.put(nn.getId(), nnData);
            }
            double visitCost = currCost + this.tcFunction.getLinkTravelDisutility(link, currTime, this.PERSON, this.VEHICLE);
            double visitTime = currTime + this.ttFunction.getLinkTravelTime(link, currTime, this.PERSON, this.VEHICLE);
            if (!(visitCost < nnData.getCost())) continue;
            pendingNodes.remove(nn);
            nnData.visit(n.getId(), visitCost, visitTime);
            this.additionalComputationsHook(link, currTime);
            pendingNodes.add(nn);
        }
    }

    protected void additionalComputationsHook(Link link, double currTime) {
    }

    public static void main(String[] args) {
        MutableScenario scenario = (MutableScenario)ScenarioUtils.createScenario(ConfigUtils.createConfig());
        Network network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile("../../input/network.xml");
        TravelTimeCalculator ttc = new TravelTimeCalculator(network, 60, 108000, scenario.getConfig().travelTimeCalculator());
        LeastCostPathTree st = new LeastCostPathTree(ttc.getLinkTravelTimes(), new RandomizingTimeDistanceTravelDisutilityFactory("car", scenario.getConfig().planCalcScore()).createTravelDisutility(ttc.getLinkTravelTimes()));
        Node origin = network.getNodes().get(Id.create(1L, Node.class));
        st.calculate(network, origin, 28800.0);
        Map<Id<Node>, NodeData> tree = st.getTree();
        for (Map.Entry<Id<Node>, NodeData> e : tree.entrySet()) {
            Id<Node> id = e.getKey();
            NodeData d = e.getValue();
            if (d.getPrevNodeId() != null) {
                System.out.println(id + "\t" + d.getTime() + "\t" + d.getCost() + "\t" + d.getPrevNodeId());
                continue;
            }
            System.out.println(id + "\t" + d.getTime() + "\t" + d.getCost() + "\t" + "0");
        }
    }

    static class ComparatorCost
    implements Comparator<Node> {
        protected Map<Id<Node>, ? extends NodeData> nodeData;

        ComparatorCost(Map<Id<Node>, ? extends NodeData> nodeData) {
            this.nodeData = nodeData;
        }

        @Override
        public int compare(Node n1, Node n2) {
            double c2;
            double c1 = this.getCost(n1);
            if (c1 < (c2 = this.getCost(n2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return n1.getId().compareTo(n2.getId());
        }

        protected double getCost(Node node) {
            return this.nodeData.get(node.getId()).getCost();
        }
    }

    public static class NodeData {
        private Id<Node> prevId = null;
        private double cost = Double.MAX_VALUE;
        private double time = 0.0;

        void visit(Id<Node> comingFromNodeId, double cost1, double time1) {
            this.prevId = comingFromNodeId;
            this.cost = cost1;
            this.time = time1;
        }

        public double getCost() {
            return this.cost;
        }

        public double getTime() {
            return this.time;
        }

        public Id<Node> getPrevNodeId() {
            return this.prevId;
        }
    }
}

