/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import org.apache.log4j.Logger;
import org.matsim.utils.objectattributes.AttributeConverter;

public class DoubleArrayConverter
implements AttributeConverter<double[]> {
    private static String DELIMITER = ",";

    @Override
    public double[] convert(String value) {
        String[] values = value.split(DELIMITER);
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Double.parseDouble(values[i]);
        }
        return result;
    }

    @Override
    public String convertToString(Object o) {
        if (!(o instanceof double[])) {
            Logger.getLogger(this.getClass()).error("Object is not of type double[] " + o.getClass().toString());
            return null;
        }
        double[] s2 = (double[])o;
        String result = "";
        for (int i = 0; i < s2.length; ++i) {
            result = result + Double.toString(s2[i]);
            if (i >= s2.length - 1) continue;
            result = result + DELIMITER;
        }
        return result;
    }
}

