/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.core.api.internal.MatsimExtensionPoint;

public class ObjectAttributes
implements MatsimExtensionPoint {
    Map<String, Map<String, Object>> attributes = new LinkedHashMap<String, Map<String, Object>>(1000);

    public String toString() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry<String, Map<String, Object>> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            stb.append("key=").append(key);
            Map<String, Object> map = entry.getValue();
            for (Map.Entry<String, Object> ee : map.entrySet()) {
                String subkey = ee.getKey();
                stb.append("; subkey=").append(subkey);
                stb.append("; object=").append(ee.getValue().toString());
            }
            stb.append("\n");
        }
        return stb.toString();
    }

    public Object putAttribute(String objectId, String attribute, Object value) {
        Map<String, Object> attMap = this.attributes.get(objectId);
        if (attMap == null) {
            attMap = new IdentityHashMap<String, Object>(5);
            this.attributes.put(objectId, attMap);
        }
        return attMap.put(attribute.intern(), value);
    }

    public Object getAttribute(String objectId, String attribute) {
        Map<String, Object> attMap = this.attributes.get(objectId);
        if (attMap == null) {
            return null;
        }
        return attMap.get(attribute.intern());
    }

    public Object removeAttribute(String objectId, String attribute) {
        Map<String, Object> attMap = this.attributes.get(objectId);
        if (attMap == null) {
            return null;
        }
        return attMap.remove(attribute.intern());
    }

    public void removeAllAttributes(String objectId) {
        this.attributes.remove(objectId);
    }

    public void clear() {
        this.attributes.clear();
    }
}

