/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.DoubleArrayConverter;
import org.matsim.utils.objectattributes.attributeconverters.BooleanConverter;
import org.matsim.utils.objectattributes.attributeconverters.DoubleConverter;
import org.matsim.utils.objectattributes.attributeconverters.EnumConverter;
import org.matsim.utils.objectattributes.attributeconverters.FloatConverter;
import org.matsim.utils.objectattributes.attributeconverters.IntegerConverter;
import org.matsim.utils.objectattributes.attributeconverters.LongConverter;
import org.matsim.utils.objectattributes.attributeconverters.StringConverter;

public class ObjectAttributesConverter {
    private static final Logger log = Logger.getLogger(ObjectAttributesConverter.class);
    private final Map<String, AttributeConverter<?>> converters = new HashMap();
    private final Set<String> missingConverters = new HashSet<String>();

    @Inject
    public ObjectAttributesConverter(Map<Class<?>, AttributeConverter<?>> converters) {
        this();
        this.putAttributeConverters(converters);
    }

    public ObjectAttributesConverter() {
        this.converters.put(String.class.getCanonicalName(), new StringConverter());
        this.converters.put(Integer.class.getCanonicalName(), new IntegerConverter());
        this.converters.put(Float.class.getCanonicalName(), new FloatConverter());
        this.converters.put(Double.class.getCanonicalName(), new DoubleConverter());
        this.converters.put(Boolean.class.getCanonicalName(), new BooleanConverter());
        this.converters.put(Long.class.getCanonicalName(), new LongConverter());
        this.converters.put(double[].class.getCanonicalName(), new DoubleArrayConverter());
    }

    public Object convert(String className, String value) {
        AttributeConverter converter = this.getConverter(className);
        return converter == null ? null : converter.convert(value);
    }

    private AttributeConverter getConverter(String className) {
        block5: {
            if (this.converters.containsKey(className)) {
                return this.converters.get(className);
            }
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isEnum()) {
                    EnumConverter converter = new EnumConverter(clazz);
                    this.converters.put(className, converter);
                    return converter;
                }
                if (this.missingConverters.add(className)) {
                    log.warn("No AttributeConverter found for class " + className + ". Not all attribute values can be converted.");
                }
            }
            catch (ClassNotFoundException e) {
                if (!this.missingConverters.add(className)) break block5;
                log.warn("No AttributeConverter found for class " + className + ", and class is not on classpath. Not all attribute values can be converted.");
            }
        }
        return null;
    }

    public String convertToString(Object o) {
        AttributeConverter converter = this.getConverter(o.getClass().getCanonicalName());
        return converter == null ? null : converter.convertToString(o);
    }

    public AttributeConverter putAttributeConverter(Class<?> clazz, AttributeConverter converter) {
        return this.converters.put(clazz.getCanonicalName(), converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        for (Map.Entry<Class<?>, AttributeConverter<?>> e : converters.entrySet()) {
            this.putAttributeConverter(e.getKey(), e.getValue());
        }
    }

    public AttributeConverter removeAttributeConverter(Class<?> clazz) {
        return this.converters.remove(clazz.getCanonicalName());
    }
}

