/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.matsim.utils.objectattributes.ObjectAttributes;

public final class ObjectAttributesUtils {
    private ObjectAttributesUtils() {
    }

    public static void copyAllAttributes(ObjectAttributes source, ObjectAttributes destination, String objectId) {
        Map<String, Object> sAttrs = source.attributes.get(objectId);
        if (sAttrs != null) {
            Map<String, Object> dAttrs = destination.attributes.get(objectId);
            if (dAttrs == null) {
                dAttrs = new IdentityHashMap<String, Object>();
                destination.attributes.put(objectId, dAttrs);
            }
            dAttrs.putAll(sAttrs);
        }
    }

    public static Collection<String> getAllAttributeNames(ObjectAttributes attributes, String objectId) {
        Map<String, Object> map = attributes.attributes.get(objectId);
        if (map == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(map.keySet());
    }
}

