/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ObjectAttributesXmlReader
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(ObjectAttributesXmlReader.class);
    private final ObjectAttributesConverter converter = new ObjectAttributesConverter();
    private final ObjectAttributes attributes;
    private boolean readCharacters = false;
    private String currentObject = null;
    private String currentAttribute = null;
    private String currentAttributeClass = null;
    private long count = 0L;

    public ObjectAttributesXmlReader(ObjectAttributes attributes) {
        this.attributes = attributes;
        super.setValidating(false);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if ("attribute".equals(name)) {
            this.currentAttribute = atts.getValue("name");
            this.currentAttributeClass = atts.getValue("class");
            this.readCharacters = true;
        } else if ("object".equals(name)) {
            this.currentObject = atts.getValue("id");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if ("attribute".equals(name)) {
            this.readCharacters = false;
            Object o = this.converter.convert(this.currentAttributeClass, content);
            this.attributes.putAttribute(this.currentObject, this.currentAttribute, o);
        } else if ("object".equals(name)) {
            if (this.count % 100000L == 0L) {
                log.info("reading object #" + this.count);
            }
            ++this.count;
            this.currentObject = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.readCharacters) {
            super.characters(ch, start, length);
        }
    }

    public AttributeConverter<?> putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        return this.converter.putAttributeConverter(clazz, converter);
    }

    @Inject
    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converter.putAttributeConverters(converters);
    }

    public AttributeConverter<?> removeAttributeConverter(Class<?> clazz) {
        return this.converter.removeAttributeConverter(clazz);
    }
}

