/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;

public class ObjectAttributesXmlWriter
extends MatsimXmlWriter {
    private static final Logger log = Logger.getLogger(ObjectAttributesXmlWriter.class);
    static final String TAG_OBJECT_ATTRIBUTES = "objectAttributes";
    static final String TAG_OBJECT = "object";
    static final String TAG_ATTRIBUTE = "attribute";
    static final String ATTR_OBJECTID = "id";
    static final String ATTR_ATTRIBUTENAME = "name";
    static final String ATTR_ATTRIBUTECLASS = "class";
    private final ObjectAttributes attributes;
    private final ObjectAttributesConverter converter = new ObjectAttributesConverter();

    public ObjectAttributesXmlWriter(ObjectAttributes attributes) {
        this.attributes = attributes;
    }

    public void writeFile(String filename) throws UncheckedIOException {
        this.openFile(filename);
        this.writeXmlHead();
        this.writeDoctype(TAG_OBJECT_ATTRIBUTES, "http://matsim.org/files/dtd/objectattributes_v1.dtd");
        this.writeStartTag(TAG_OBJECT_ATTRIBUTES, null);
        LinkedList<Tuple<String, String>> xmlAttributes = new LinkedList<Tuple<String, String>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.attributes.attributes.entrySet()) {
            xmlAttributes.add(MatsimXmlWriter.createTuple(ATTR_OBJECTID, entry.getKey()));
            this.writeStartTag(TAG_OBJECT, xmlAttributes);
            xmlAttributes.clear();
            TreeMap<String, Object> objAttributes = new TreeMap<String, Object>();
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                objAttributes.put(entry2.getKey(), entry2.getValue());
            }
            for (Map.Entry<String, Object> entry3 : objAttributes.entrySet()) {
                Class<?> clazz = entry3.getValue().getClass();
                String value = this.converter.convertToString(entry3.getValue());
                if (value == null) continue;
                xmlAttributes.add(MatsimXmlWriter.createTuple(ATTR_ATTRIBUTENAME, entry3.getKey()));
                xmlAttributes.add(MatsimXmlWriter.createTuple(ATTR_ATTRIBUTECLASS, clazz.getCanonicalName()));
                this.writeStartTag(TAG_ATTRIBUTE, xmlAttributes);
                xmlAttributes.clear();
                this.writeContent(value, false);
                this.writeEndTag(TAG_ATTRIBUTE);
            }
            this.writeEndTag(TAG_OBJECT);
        }
        this.writeEndTag(TAG_OBJECT_ATTRIBUTES);
        this.close();
    }

    public AttributeConverter putAttributeConverter(Class<?> clazz, AttributeConverter converter) {
        return this.converter.putAttributeConverter(clazz, converter);
    }

    @Inject
    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converter.putAttributeConverters(converters);
    }

    public AttributeConverter removeAttributeConverter(Class<?> clazz) {
        return this.converter.removeAttributeConverter(clazz);
    }
}

