/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes;

import java.util.ArrayList;
import java.util.List;
import org.matsim.utils.objectattributes.ObjectAttributes;

public class RunObjectAttributesExample {
    public static void main(String[] args) {
        ArrayList<String> linkIds = new ArrayList<String>();
        linkIds.add("1");
        linkIds.add("2");
        linkIds.add("3");
        linkIds.add("4");
        ObjectAttributes linkAttributes = new ObjectAttributes();
        linkAttributes.putAttribute("1", "roadtype", "motorway");
        linkAttributes.putAttribute("1", "hasSpeedBumps", Boolean.TRUE);
        linkAttributes.putAttribute("2", "roadtype", "trunk");
        linkAttributes.putAttribute("2", "hasSpeedBumps", Boolean.TRUE);
        linkAttributes.putAttribute("3", "hasSpeedBumps", Boolean.FALSE);
        RunObjectAttributesExample.filterByAttributes(linkIds, linkAttributes, "roadtype", "trunk");
        RunObjectAttributesExample.filterByAttributes(linkIds, linkAttributes, "hasSpeedBumps", true);
        RunObjectAttributesExample.filterByAttributes(linkIds, linkAttributes, "hasSpeedBumps", false);
    }

    public static void filterByAttributes(List<String> objectIds, ObjectAttributes objectAttributes, String attributeName, Object attributeValue) {
        System.out.println("filtering for " + attributeName + " = " + attributeValue);
        for (String id : objectIds) {
            Object o = objectAttributes.getAttribute(id, attributeName);
            if (!attributeValue.equals(o)) continue;
            System.out.println("  " + id);
        }
    }
}

