/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes.attributable;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Attributes {
    private static final String[] EMPTY_KEYS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private String[] keys = EMPTY_KEYS;
    private Object[] values = EMPTY_VALUES;

    public String toString() {
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < this.keys.length; ++i) {
            String subkey = this.keys[i];
            stb.append("{ key=").append(subkey);
            stb.append("; object=").append(this.values[i].toString());
            stb.append(" }");
        }
        return stb.toString();
    }

    public Object putAttribute(String attribute, Object value) {
        int insertion = Arrays.binarySearch(this.keys, attribute);
        if (insertion >= 0) {
            Object prev = this.values[insertion];
            this.values[insertion] = value;
            return prev;
        }
        int newIndex = -insertion - 1;
        this.keys = Arrays.copyOf(this.keys, this.keys.length + 1);
        this.values = Arrays.copyOf(this.values, this.values.length + 1);
        for (int i = this.keys.length - 2; i >= newIndex; --i) {
            this.keys[i + 1] = this.keys[i];
            this.values[i + 1] = this.values[i];
        }
        this.keys[newIndex] = attribute;
        this.values[newIndex] = value;
        return null;
    }

    public Object getAttribute(String attribute) {
        int insertion = Arrays.binarySearch(this.keys, attribute);
        if (insertion < 0) {
            return null;
        }
        return this.values[insertion];
    }

    public Object removeAttribute(String attribute) {
        int insertion = Arrays.binarySearch(this.keys, attribute);
        if (insertion < 0) {
            return null;
        }
        Object prev = this.values[insertion];
        for (int i = insertion; i < this.keys.length - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
        }
        this.keys = Arrays.copyOf(this.keys, this.keys.length - 1);
        this.values = Arrays.copyOf(this.values, this.values.length - 1);
        return prev;
    }

    public void clear() {
        this.keys = EMPTY_KEYS;
        this.values = EMPTY_VALUES;
    }

    public Map<String, Object> getAsMap() {
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return new EntryIterator();
                    }

                    @Override
                    public int size() {
                        return Attributes.this.keys.length;
                    }
                };
            }
        };
    }

    public int size() {
        return this.keys.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, Object>> {
        private int index = 0;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Attributes.this.keys.length;
        }

        @Override
        public Map.Entry<String, Object> next() {
            AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(Attributes.this.keys[this.index], Attributes.this.values[this.index]);
            ++this.index;
            return entry;
        }
    }
}

