/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes.attributable;

import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class AttributesXmlReaderDelegate {
    private static final Logger log = Logger.getLogger(AttributesXmlReaderDelegate.class);
    private final ObjectAttributesConverter converter = new ObjectAttributesConverter();
    private Attributes currentAttributes = null;
    private String currentAttribute = null;
    private String currentAttributeClass = null;
    static final String TAG_ATTRIBUTES = "attributes";
    static final String TAG_ATTRIBUTE = "attribute";
    static final String ATTR_ATTRIBUTENAME = "name";
    static final String ATTR_ATTRIBUTECLASS = "class";

    public void startTag(String name, org.xml.sax.Attributes atts, Stack<String> context, Attributes currentAttributes) {
        if (TAG_ATTRIBUTE.equals(name)) {
            this.currentAttribute = atts.getValue(ATTR_ATTRIBUTENAME);
            this.currentAttributeClass = atts.getValue(ATTR_ATTRIBUTECLASS);
        } else if (TAG_ATTRIBUTES.equals(name)) {
            this.currentAttributes = currentAttributes;
        }
    }

    public void endTag(String name, String content, Stack<String> context) {
        if (TAG_ATTRIBUTE.equals(name)) {
            Object o = this.converter.convert(this.currentAttributeClass, content);
            if (o == null) {
                return;
            }
            this.currentAttributes.putAttribute(this.currentAttribute, o);
        }
    }

    public Attributes getCurrentAttributes() {
        return this.currentAttributes;
    }

    public AttributeConverter<?> putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        return this.converter.putAttributeConverter(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        for (Map.Entry<Class<?>, AttributeConverter<?>> e : converters.entrySet()) {
            this.putAttributeConverter(e.getKey(), e.getValue());
        }
    }

    public AttributeConverter<?> removeAttributeConverter(Class<?> clazz) {
        return this.converter.removeAttributeConverter(clazz);
    }
}

