/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes.attributable;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.io.XmlUtils;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class AttributesXmlWriterDelegate {
    private final ObjectAttributesConverter converter = new ObjectAttributesConverter();

    public final void writeAttributes(String indentation, BufferedWriter writer, Attributes attributes) {
        if (attributes.size() == 0) {
            return;
        }
        try {
            writer.write(indentation);
            writer.write("<attributes>");
            writer.newLine();
            for (Map.Entry<String, Object> objAttribute : attributes.getAsMap().entrySet()) {
                Class<?> clazz = objAttribute.getValue().getClass();
                String converted = this.converter.convertToString(objAttribute.getValue());
                if (converted == null) continue;
                writer.write(indentation + "\t");
                writer.write("<attribute name=\"" + XmlUtils.encodeAttributeValue(objAttribute.getKey()) + "\" ");
                writer.write("class=\"" + clazz.getCanonicalName() + "\" >");
                writer.write(XmlUtils.encodeContent(converted));
                writer.write("</attribute>");
                writer.newLine();
            }
            writer.write(indentation);
            writer.write("</attributes>");
            writer.newLine();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converter.putAttributeConverters(converters);
    }
}

