/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.utils.objectattributes.attributeconverters;

import org.matsim.utils.objectattributes.AttributeConverter;

public class EnumConverter<E extends Enum<E>>
implements AttributeConverter<E> {
    private final Class<E> clazz;

    public EnumConverter(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E convert(String value) {
        return Enum.valueOf(this.clazz, value);
    }

    @Override
    public String convertToString(Object o) {
        if (o.getClass() != this.clazz) {
            throw new IllegalArgumentException("got " + o.getClass().getCanonicalName() + ", expected " + this.clazz.getCanonicalName());
        }
        return ((Enum)o).name();
    }
}

