/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vehicles;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.vehicles.EngineInformation;
import org.matsim.vehicles.FreightCapacity;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleCapacity;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.Vehicles;
import org.matsim.vehicles.VehiclesFactory;
import org.xml.sax.Attributes;

public class VehicleReaderV1
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(VehicleReaderV1.class);
    private final Vehicles vehicles;
    private final VehiclesFactory builder;
    private VehicleType currentVehType = null;
    private VehicleCapacity currentCapacity = null;
    private FreightCapacity currentFreightCap = null;
    private EngineInformation.FuelType currentFuelType = null;
    private double currentGasConsumption = Double.NaN;

    public VehicleReaderV1(Vehicles vehicles) {
        this.vehicles = vehicles;
        this.builder = this.vehicles.getFactory();
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if ("description".equalsIgnoreCase(name) && content.trim().length() > 0) {
            this.currentVehType.setDescription(content.trim());
        } else if ("engineInformation".equalsIgnoreCase(name)) {
            EngineInformation currentEngineInfo = this.builder.createEngineInformation(this.currentFuelType, this.currentGasConsumption);
            this.currentVehType.setEngineInformation(currentEngineInfo);
            this.currentFuelType = null;
            this.currentGasConsumption = Double.NaN;
        } else if ("fuelType".equalsIgnoreCase(name)) {
            this.currentFuelType = this.parseFuelType(content.trim());
        } else if ("freightCapacity".equalsIgnoreCase(name)) {
            this.currentCapacity.setFreightCapacity(this.currentFreightCap);
            this.currentFreightCap = null;
        } else if ("capacity".equalsIgnoreCase(name)) {
            this.currentVehType.setCapacity(this.currentCapacity);
            this.currentCapacity = null;
        } else if ("vehicleType".equalsIgnoreCase(name)) {
            this.vehicles.addVehicleType(this.currentVehType);
            this.currentVehType = null;
        }
    }

    private EngineInformation.FuelType parseFuelType(String content) {
        if (EngineInformation.FuelType.gasoline.toString().equalsIgnoreCase(content)) {
            return EngineInformation.FuelType.gasoline;
        }
        if (EngineInformation.FuelType.diesel.toString().equalsIgnoreCase(content)) {
            return EngineInformation.FuelType.diesel;
        }
        if (EngineInformation.FuelType.electricity.toString().equalsIgnoreCase(content)) {
            return EngineInformation.FuelType.electricity;
        }
        if (EngineInformation.FuelType.biodiesel.toString().equalsIgnoreCase(content)) {
            return EngineInformation.FuelType.biodiesel;
        }
        throw new IllegalArgumentException("Fuel type: " + content + " is not supported!");
    }

    private VehicleType.DoorOperationMode parseDoorOperationMode(String modeString) {
        if (VehicleType.DoorOperationMode.serial.toString().equalsIgnoreCase(modeString)) {
            return VehicleType.DoorOperationMode.serial;
        }
        if (VehicleType.DoorOperationMode.parallel.toString().equalsIgnoreCase(modeString)) {
            return VehicleType.DoorOperationMode.parallel;
        }
        throw new IllegalArgumentException("Door operation mode " + modeString + " is not supported");
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if ("vehicleType".equalsIgnoreCase(name)) {
            this.currentVehType = this.builder.createVehicleType(Id.create(atts.getValue("id"), VehicleType.class));
        } else if ("length".equalsIgnoreCase(name)) {
            this.currentVehType.setLength(Double.parseDouble(atts.getValue("meter")));
        } else if ("width".equalsIgnoreCase(name)) {
            this.currentVehType.setWidth(Double.parseDouble(atts.getValue("meter")));
        } else if ("maximumVelocity".equalsIgnoreCase(name)) {
            double val = Double.parseDouble(atts.getValue("meterPerSecond"));
            if (val == 1.0) {
                log.warn("The vehicle type's maximum velocity is set to 1.0 meter per second, is this really intended? vehicletype = " + this.currentVehType.getId().toString());
            }
            this.currentVehType.setMaximumVelocity(val);
        } else if ("capacity".equalsIgnoreCase(name)) {
            this.currentCapacity = this.builder.createVehicleCapacity();
        } else if ("seats".equalsIgnoreCase(name)) {
            this.currentCapacity.setSeats(Integer.valueOf(atts.getValue("persons")));
        } else if ("standingRoom".equalsIgnoreCase(name)) {
            this.currentCapacity.setStandingRoom(Integer.valueOf(atts.getValue("persons")));
        } else if ("freightCapacity".equalsIgnoreCase(name)) {
            this.currentFreightCap = this.builder.createFreigthCapacity();
        } else if ("volume".equalsIgnoreCase(name)) {
            this.currentFreightCap.setVolume(Double.parseDouble(atts.getValue("cubicMeters")));
        } else if ("gasConsumption".equalsIgnoreCase(name)) {
            this.currentGasConsumption = Double.parseDouble(atts.getValue("literPerMeter"));
        } else if ("vehicle".equalsIgnoreCase(name)) {
            Id<VehicleType> typeId = Id.create(atts.getValue("type"), VehicleType.class);
            VehicleType type = this.vehicles.getVehicleTypes().get(typeId);
            if (type == null) {
                log.error("VehicleType " + typeId + " does not exist.");
            }
            String idString = atts.getValue("id");
            Id<Vehicle> id = Id.create(idString, Vehicle.class);
            Vehicle v = this.builder.createVehicle(id, type);
            this.vehicles.addVehicle(v);
        } else if ("accessTime".equalsIgnoreCase(name)) {
            this.currentVehType.setAccessTime(Double.parseDouble(atts.getValue("secondsPerPerson")));
        } else if ("egressTime".equalsIgnoreCase(name)) {
            this.currentVehType.setEgressTime(Double.parseDouble(atts.getValue("secondsPerPerson")));
        } else if ("doorOperation".equalsIgnoreCase(name)) {
            this.currentVehType.setDoorOperationMode(this.parseDoorOperationMode(atts.getValue("mode")));
        } else if ("passengerCarEquivalents".equalsIgnoreCase(name)) {
            this.currentVehType.setPcuEquivalents(Double.parseDouble(atts.getValue("pce")));
        }
    }
}

