/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vehicles;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleCapacityImpl;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.Vehicles;
import org.matsim.vehicles.VehiclesFactory;
import org.matsim.vehicles.VehiclesFactoryImpl;
import org.matsim.vehicles.VehiclesImpl;

public class VehicleUtils {
    private static final VehicleType DEFAULT_VEHICLE_TYPE = VehicleUtils.getFactory().createVehicleType(Id.create("defaultVehicleType", VehicleType.class));
    private static final String VEHICLE_ATTRIBUTE_KEY = "vehicles";

    public static VehiclesFactory getFactory() {
        return new VehiclesFactoryImpl();
    }

    public static Vehicles createVehiclesContainer() {
        return new VehiclesImpl();
    }

    public static VehicleType getDefaultVehicleType() {
        return DEFAULT_VEHICLE_TYPE;
    }

    public static Id<Vehicle> createVehicleId(Person person, String mode) {
        return Id.createVehicleId(person.getId().toString() + "_" + mode);
    }

    public static Id<Vehicle> getVehicleId(Person person, String mode) {
        Map vehicleIds = (Map)person.getAttributes().getAttribute(VEHICLE_ATTRIBUTE_KEY);
        if (vehicleIds == null || !vehicleIds.containsKey(mode)) {
            throw new RuntimeException("Could not retrieve vehicle id from person: " + person.getId().toString() + " for mode: " + mode + ". \nIf you are not using config.qsim().getVehicleSource() with 'defaultVehicle' or 'modeVehicleTypesFromVehiclesData' you have to provide " + "a vehicle for each mode for each person. Attach a map of mode:String -> id:Id<Vehicle> with key 'vehicles' as person attribute to each person." + "\n VehicleUtils.insertVehicleIdIntoAttributes does this for you.");
        }
        return (Id)vehicleIds.get(mode);
    }

    public static void insertVehicleIdIntoAttributes(Person person, String mode, Id<Vehicle> vehicleId) {
        Object attr = person.getAttributes().getAttribute(VEHICLE_ATTRIBUTE_KEY);
        Map<String, Id<Vehicle>> map = attr == null ? new HashMap() : (Map)attr;
        map.put(mode, vehicleId);
        person.getAttributes().putAttribute(VEHICLE_ATTRIBUTE_KEY, map);
    }

    static {
        VehicleCapacityImpl capacity = new VehicleCapacityImpl();
        capacity.setSeats(4);
        DEFAULT_VEHICLE_TYPE.setCapacity(capacity);
    }
}

