/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vehicles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.vehicles.EngineInformation;
import org.matsim.vehicles.FreightCapacity;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleCapacity;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.Vehicles;

public class VehicleWriterV1
extends MatsimXmlWriter {
    private static final Logger log = Logger.getLogger(VehicleWriterV1.class);
    private List<Tuple<String, String>> atts = new ArrayList<Tuple<String, String>>();
    private Map<Id<VehicleType>, VehicleType> vehicleTypes;
    private Map<Id<Vehicle>, Vehicle> vehicles;

    public VehicleWriterV1(Vehicles vehicles) {
        this.vehicleTypes = vehicles.getVehicleTypes();
        this.vehicles = vehicles.getVehicles();
    }

    public void writeFile(String filename) throws UncheckedIOException {
        log.info(Gbl.aboutToWrite("vehicles", filename));
        this.openFile(filename);
        this.writeXmlHead();
        this.writeRootElement();
        this.close();
    }

    private void writeRootElement() throws UncheckedIOException {
        this.atts.clear();
        this.atts.add(VehicleWriterV1.createTuple("xmlns", "http://www.matsim.org/files/dtd"));
        this.atts.add(VehicleWriterV1.createTuple("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        this.atts.add(VehicleWriterV1.createTuple("xsi:schemaLocation", "http://www.matsim.org/files/dtd http://www.matsim.org/files/dtd/vehicleDefinitions_v1.0.xsd"));
        this.writeStartTag("vehicleDefinitions", this.atts);
        this.writeVehicleTypes(this.vehicleTypes);
        this.writeVehicles(this.vehicles);
        this.writeEndTag("vehicleDefinitions");
    }

    private void writeVehicles(Map<Id<Vehicle>, Vehicle> veh) throws UncheckedIOException {
        for (Vehicle v : veh.values()) {
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("id", v.getId().toString()));
            this.atts.add(VehicleWriterV1.createTuple("type", v.getType().getId().toString()));
            this.writeStartTag("vehicle", this.atts, true);
        }
    }

    private void writeVehicleTypes(Map<Id<VehicleType>, VehicleType> vts) throws UncheckedIOException {
        for (VehicleType vt : vts.values()) {
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("id", vt.getId().toString()));
            this.writeStartTag("vehicleType", this.atts);
            if (vt.getDescription() != null) {
                this.writeStartTag("description", null);
                this.writeContent(vt.getDescription(), true);
                this.writeEndTag("description");
            }
            if (vt.getCapacity() != null) {
                this.writeCapacity(vt.getCapacity());
            }
            if (!Double.isNaN(vt.getLength())) {
                this.atts.clear();
                this.atts.add(VehicleWriterV1.createTuple("meter", Double.toString(vt.getLength())));
                this.writeStartTag("length", this.atts, true);
            }
            if (!Double.isNaN(vt.getWidth())) {
                this.atts.clear();
                this.atts.add(VehicleWriterV1.createTuple("meter", Double.toString(vt.getWidth())));
                this.writeStartTag("width", this.atts, true);
            }
            if (!Double.isNaN(vt.getMaximumVelocity()) && !Double.isInfinite(vt.getMaximumVelocity())) {
                this.atts.clear();
                this.atts.add(VehicleWriterV1.createTuple("meterPerSecond", Double.toString(vt.getMaximumVelocity())));
                this.writeStartTag("maximumVelocity", this.atts, true);
            }
            if (vt.getEngineInformation() != null) {
                this.writeEngineInformation(vt.getEngineInformation());
            }
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("secondsPerPerson", vt.getAccessTime()));
            this.writeStartTag("accessTime", this.atts, true);
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("secondsPerPerson", vt.getEgressTime()));
            this.writeStartTag("egressTime", this.atts, true);
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("mode", vt.getDoorOperationMode().toString()));
            this.writeStartTag("doorOperation", this.atts, true);
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("pce", vt.getPcuEquivalents()));
            this.writeStartTag("passengerCarEquivalents", this.atts, true);
            this.writeEndTag("vehicleType");
        }
    }

    private void writeEngineInformation(EngineInformation ei) throws UncheckedIOException {
        this.writeStartTag("engineInformation", null);
        this.writeStartTag("fuelType", null);
        this.writeContent(ei.getFuelType().toString(), false);
        this.writeEndTag("fuelType");
        this.atts.clear();
        this.atts.add(VehicleWriterV1.createTuple("literPerMeter", Double.toString(ei.getGasConsumption())));
        this.writeStartTag("gasConsumption", this.atts, true);
        this.writeEndTag("engineInformation");
    }

    private void writeCapacity(VehicleCapacity cap) throws UncheckedIOException {
        this.writeStartTag("capacity", null);
        if (cap.getSeats() != null) {
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("persons", cap.getSeats()));
            this.writeStartTag("seats", this.atts, true);
        }
        if (cap.getStandingRoom() != null) {
            this.atts.clear();
            this.atts.add(VehicleWriterV1.createTuple("persons", cap.getStandingRoom()));
            this.writeStartTag("standingRoom", this.atts, true);
        }
        if (cap.getFreightCapacity() != null) {
            this.writeFreightCapacity(cap.getFreightCapacity());
        }
        this.writeEndTag("capacity");
    }

    private void writeFreightCapacity(FreightCapacity fc) throws UncheckedIOException {
        this.writeStartTag("freightCapacity", null);
        this.atts.clear();
        this.atts.add(VehicleWriterV1.createTuple("cubicMeters", Double.toString(fc.getVolume())));
        this.writeStartTag("volume", this.atts, true);
        this.writeEndTag("freightCapacity");
    }
}

