/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vehicles;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.core.utils.misc.Counter;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.Vehicles;
import org.matsim.vehicles.VehiclesFactory;
import org.matsim.vehicles.VehiclesFactoryImpl;

class VehiclesImpl
implements Vehicles {
    private final Map<Id<VehicleType>, VehicleType> vehicleTypes;
    private final LinkedHashMap<Id<Vehicle>, Vehicle> vehicles;
    private final VehiclesFactoryImpl builder;
    private final ObjectAttributes vehicleAttributes = new ObjectAttributes();
    private final Counter counter = new Counter("[VehiclesImpl] added vehicle # ");

    VehiclesImpl() {
        this.vehicleTypes = new LinkedHashMap<Id<VehicleType>, VehicleType>();
        this.builder = new VehiclesFactoryImpl();
        this.vehicles = new LinkedHashMap();
    }

    @Override
    public VehiclesFactory getFactory() {
        return this.builder;
    }

    @Override
    public final Map<Id<Vehicle>, Vehicle> getVehicles() {
        return Collections.unmodifiableMap(this.vehicles);
    }

    @Override
    public Map<Id<VehicleType>, VehicleType> getVehicleTypes() {
        return Collections.unmodifiableMap(this.vehicleTypes);
    }

    @Override
    public void addVehicle(Vehicle v) {
        if (this.getVehicles().containsKey(v.getId())) {
            throw new IllegalArgumentException("Vehicle with id = " + v.getId() + " already exists.");
        }
        if (!this.vehicleTypes.containsKey(v.getType().getId())) {
            throw new IllegalArgumentException("Cannot add Vehicle with type = " + v.getType().getId().toString() + " if the VehicleType has not been added to the Vehicles container.");
        }
        this.vehicles.put(v.getId(), v);
        this.counter.incCounter();
    }

    @Override
    public void removeVehicle(Id<Vehicle> vehicleId) {
        this.vehicles.remove(vehicleId);
    }

    @Override
    public void addVehicleType(VehicleType type) {
        if (this.getVehicleTypes().containsKey(type.getId())) {
            throw new IllegalArgumentException("Vehicle type with id = " + type.getId() + " already exists.");
        }
        this.vehicleTypes.put(type.getId(), type);
    }

    @Override
    public void removeVehicleType(Id<VehicleType> vehicleTypeId) {
        for (Vehicle veh : this.vehicles.values()) {
            if (!veh.getType().getId().equals(vehicleTypeId)) continue;
            throw new IllegalArgumentException("Cannot remove vehicle type as it is used by at least one vehicle.");
        }
        this.vehicleTypes.remove(vehicleTypeId);
    }

    @Override
    public ObjectAttributes getVehicleAttributes() {
        return this.vehicleAttributes;
    }
}

