/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.kml;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.opengis.kml.v_2_2_0.KmlType;
import net.opengis.kml.v_2_2_0.LinkType;
import net.opengis.kml.v_2_2_0.NetworkLinkType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimSomeWriter;

public class KMZWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(KMZWriter.class);
    private BufferedWriter out = null;
    private ZipOutputStream zipOut = null;
    private final Map<String, String> nonKmlFiles = new HashMap<String, String>();
    private static final Marshaller marshaller;
    private static final ObjectFactory kmlObjectFactory;

    public KMZWriter(String outFilename) {
        log.setLevel(Level.INFO);
        String filename = outFilename;
        if (filename.endsWith(".kml") || filename.endsWith(".kmz")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        try {
            this.zipOut = new ZipOutputStream(new FileOutputStream(filename + ".kmz"));
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)this.zipOut, "UTF8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KmlType docKML = kmlObjectFactory.createKmlType();
        NetworkLinkType nl = kmlObjectFactory.createNetworkLinkType();
        LinkType link = kmlObjectFactory.createLinkType();
        link.setHref("main.kml");
        nl.setLink(link);
        docKML.setAbstractFeatureGroup(kmlObjectFactory.createNetworkLink(nl));
        this.writeKml("doc.kml", docKML);
    }

    public void writeLinkedKml(String filename, KmlType kml) {
        if (filename.equals("doc.kml")) {
            throw new IllegalArgumentException("The filename 'doc.kml' is reserved for the primary kml.");
        }
        if (filename.equals("main.kml")) {
            throw new IllegalArgumentException("The filename 'main.kml' is reserved for the main kml.");
        }
        this.writeKml(filename, kml);
    }

    public void writeMainKml(KmlType kml) {
        this.writeKml("main.kml", kml);
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonKMLFile(String filename, String inZipFilename) throws IOException {
        if (this.nonKmlFiles.containsKey(filename) && inZipFilename.compareTo(this.nonKmlFiles.get(filename)) == 0) {
            log.warn("File: " + filename + " is already included in the kmz as " + inZipFilename);
            return;
        }
        this.nonKmlFiles.put(filename, inZipFilename);
        try (FileInputStream fis = new FileInputStream(filename);){
            this.addNonKMLFile(fis, inZipFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonKMLFile(InputStream data, String inZipFilename) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            ZipEntry entry = new ZipEntry(inZipFilename);
            this.zipOut.putNextEntry(entry);
            while ((bytesRead = data.read(buffer)) != -1) {
                this.zipOut.write(buffer, 0, bytesRead);
            }
            log.debug(entry.getName() + " added to kmz.");
        }
        finally {
            data.close();
        }
    }

    public void addNonKMLFile(byte[] data, String inZipFilename) throws IOException {
        ZipEntry entry = new ZipEntry(inZipFilename);
        this.zipOut.putNextEntry(entry);
        this.zipOut.write(data);
        log.debug(entry.getName() + " added to kmz.");
    }

    private void writeKml(String filename, KmlType kml) {
        try {
            ZipEntry ze = new ZipEntry(filename);
            ze.setMethod(8);
            this.zipOut.putNextEntry(ze);
            try {
                marshaller.marshal(kmlObjectFactory.createKml(kml), this.out);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        kmlObjectFactory = new ObjectFactory();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance("net.opengis.kml.v_2_2_0");
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

