/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.vis.kml;

import java.io.IOException;
import net.opengis.kml.v_2_2_0.DocumentType;
import net.opengis.kml.v_2_2_0.IconStyleType;
import net.opengis.kml.v_2_2_0.LineStyleType;
import net.opengis.kml.v_2_2_0.LinkType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import net.opengis.kml.v_2_2_0.StyleType;
import org.matsim.core.gbl.MatsimResource;
import org.matsim.vis.kml.KMZWriter;
import org.matsim.vis.kml.NetworkKmlStyleFactory;

public class MatsimKmlStyleFactory
implements NetworkKmlStyleFactory {
    public static final String DEFAULTLINKICON = "link.png";
    public static final String DEFAULTNODEICON = "node.png";
    public static final String DEFAULTNODEICONRESOURCE = "icon18.png";
    private static final Double ICONSCALE = 0.5;
    public static final byte[] MATSIMRED = new byte[]{-1, 15, 15, -66};
    private static final byte[] MATSIMGREY = new byte[]{-46, 70, 50, 50};
    private static final byte[] MATSIMWHITE = new byte[]{-26, -26, -26, -26};
    public static final byte[] MATSIMGREEN = new byte[]{-1, 20, -36, 10};
    public static final byte[] MATSIMYELLOW = new byte[]{-1, 20, -26, -26};
    private KMZWriter writer = null;
    private ObjectFactory kmlObjectFactory = new ObjectFactory();
    private DocumentType document;
    private StyleType defaultnetworknodestyle;
    private StyleType defaultnetworklinkstyle;

    public MatsimKmlStyleFactory(KMZWriter writer, DocumentType document) {
        this.writer = writer;
        this.document = document;
    }

    @Override
    public StyleType createDefaultNetworkNodeStyle() throws IOException {
        if (this.defaultnetworknodestyle == null) {
            this.defaultnetworknodestyle = this.kmlObjectFactory.createStyleType();
            this.defaultnetworknodestyle.setId("defaultnetworknodestyle");
            LinkType iconLink = this.kmlObjectFactory.createLinkType();
            iconLink.setHref(DEFAULTNODEICON);
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(DEFAULTNODEICONRESOURCE), DEFAULTNODEICON);
            IconStyleType iStyle = this.kmlObjectFactory.createIconStyleType();
            iStyle.setIcon(iconLink);
            iStyle.setColor(MATSIMRED);
            iStyle.setScale(ICONSCALE);
            this.defaultnetworknodestyle.setIconStyle(iStyle);
            this.document.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(this.defaultnetworknodestyle));
        }
        return this.defaultnetworknodestyle;
    }

    @Override
    public StyleType createDefaultNetworkLinkStyle() throws IOException {
        if (this.defaultnetworklinkstyle == null) {
            this.defaultnetworklinkstyle = this.kmlObjectFactory.createStyleType();
            this.defaultnetworklinkstyle.setId("defaultnetworklinkstyle");
            LinkType iconLink = this.kmlObjectFactory.createLinkType();
            iconLink.setHref(DEFAULTLINKICON);
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(DEFAULTNODEICONRESOURCE), DEFAULTLINKICON);
            IconStyleType iStyle = this.kmlObjectFactory.createIconStyleType();
            iStyle.setIcon(iconLink);
            iStyle.setColor(MATSIMWHITE);
            iStyle.setScale(ICONSCALE);
            this.defaultnetworklinkstyle.setIconStyle(iStyle);
            LineStyleType lineStyle = this.kmlObjectFactory.createLineStyleType();
            lineStyle.setColor(MATSIMGREY);
            lineStyle.setWidth(12.0);
            this.defaultnetworklinkstyle.setLineStyle(lineStyle);
            this.document.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(this.defaultnetworklinkstyle));
        }
        return this.defaultnetworklinkstyle;
    }
}

